/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process.last;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.last.LastQueryUtil;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;
import org.openjdk.jol.info.ClassLayout;

public class LastQueryMergeOperator
implements ProcessOperator {
    public static final long MAP_NODE_RETRAINED_SIZE = 16L + (long)Location.access$000();
    private final OperatorContext operatorContext;
    private final List<Operator> children;
    private final int inputOperatorsCount;
    private TsBlockBuilder tsBlockBuilder;
    private final TsBlock[] inputTsBlocks;
    private final int[] inputIndex;
    private final boolean[] noMoreTsBlocks;
    private boolean finished = false;
    private final Comparator<Binary> comparator;
    private final TreeMap<Binary, Location> timeSeriesSelector;

    public LastQueryMergeOperator(OperatorContext operatorContext, List<Operator> children, Comparator<Binary> comparator) {
        this.operatorContext = operatorContext;
        this.children = children;
        this.inputOperatorsCount = children.size();
        this.tsBlockBuilder = LastQueryUtil.createTsBlockBuilder();
        this.inputTsBlocks = new TsBlock[this.inputOperatorsCount];
        this.inputIndex = new int[this.inputOperatorsCount];
        this.noMoreTsBlocks = new boolean[this.inputOperatorsCount];
        this.comparator = comparator;
        this.timeSeriesSelector = new TreeMap(comparator);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        ArrayList listenableFutures = new ArrayList();
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            ListenableFuture<?> blocked;
            if (this.noMoreTsBlocks[i] || !this.empty(i) || (blocked = this.children.get(i).isBlocked()).isDone()) continue;
            listenableFutures.add(blocked);
        }
        return listenableFutures.isEmpty() ? NOT_BLOCKED : Futures.successfulAsList(listenableFutures);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TsBlock next() {
        Binary currentEndTimeSeries = null;
        boolean init = false;
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (!this.noMoreTsBlocks[i] && this.empty(i)) {
                if (this.children.get(i).hasNext()) {
                    this.inputIndex[i] = 0;
                    this.inputTsBlocks[i] = this.children.get(i).next();
                    if (this.empty(i)) return null;
                    int rowSize = this.inputTsBlocks[i].getPositionCount();
                    for (int row = 0; row < rowSize; ++row) {
                        Binary key = LastQueryUtil.getTimeSeries(this.inputTsBlocks[i], row);
                        Location location = this.timeSeriesSelector.get(key);
                        if (location != null && this.inputTsBlocks[i].getTimeByIndex(row) <= this.inputTsBlocks[location.tsBlockIndex].getTimeByIndex(location.rowIndex)) continue;
                        this.timeSeriesSelector.put(key, new Location(i, row));
                    }
                } else {
                    this.noMoreTsBlocks[i] = true;
                    this.inputTsBlocks[i] = null;
                }
            }
            if (this.empty(i)) continue;
            Binary endTimeSeries = LastQueryUtil.getTimeSeries(this.inputTsBlocks[i], this.inputTsBlocks[i].getPositionCount() - 1);
            currentEndTimeSeries = init ? (this.comparator.compare(currentEndTimeSeries, endTimeSeries) < 0 ? currentEndTimeSeries : endTimeSeries) : endTimeSeries;
            init = true;
        }
        if (this.timeSeriesSelector.isEmpty()) {
            TsBlock res = this.tsBlockBuilder.build();
            this.tsBlockBuilder.reset();
            return res;
        }
        while (!this.timeSeriesSelector.isEmpty() && this.comparator.compare(this.timeSeriesSelector.firstKey(), currentEndTimeSeries) <= 0) {
            Location location = this.timeSeriesSelector.pollFirstEntry().getValue();
            LastQueryUtil.appendLastValue(this.tsBlockBuilder, this.inputTsBlocks[location.tsBlockIndex], location.rowIndex);
        }
        this.clearTsBlockCache(currentEndTimeSeries);
        TsBlock res = this.tsBlockBuilder.build();
        this.tsBlockBuilder.reset();
        return res;
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (!this.empty(i)) {
                return true;
            }
            if (this.noMoreTsBlocks[i]) continue;
            if (this.children.get(i).hasNext()) {
                return true;
            }
            this.noMoreTsBlocks[i] = true;
            this.inputTsBlocks[i] = null;
        }
        return false;
    }

    @Override
    public void close() throws Exception {
        for (Operator child : this.children) {
            child.close();
        }
        this.tsBlockBuilder = null;
    }

    @Override
    public boolean isFinished() {
        if (this.finished) {
            return true;
        }
        this.finished = true;
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (this.noMoreTsBlocks[i] && this.empty(i)) continue;
            this.finished = false;
            break;
        }
        return this.finished;
    }

    @Override
    public long calculateMaxPeekMemory() {
        long maxPeekMemory = 0L;
        long childrenMaxPeekMemory = 0L;
        for (Operator child : this.children) {
            childrenMaxPeekMemory = Math.max(childrenMaxPeekMemory, maxPeekMemory + child.calculateMaxPeekMemory());
            maxPeekMemory += child.calculateMaxReturnSize() + child.calculateRetainedSizeAfterCallingNext();
        }
        return Math.max(maxPeekMemory += this.calculateMaxReturnSize() + (long)TSFileDescriptor.getInstance().getConfig().getMaxTsBlockLineNumber() * MAP_NODE_RETRAINED_SIZE, childrenMaxPeekMemory);
    }

    @Override
    public long calculateMaxReturnSize() {
        long maxReturnSize = 0L;
        for (Operator child : this.children) {
            maxReturnSize = Math.max(maxReturnSize, child.calculateMaxReturnSize());
        }
        return maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        long childrenSum = 0L;
        long minChildReturnSize = Long.MAX_VALUE;
        for (Operator child : this.children) {
            long maxReturnSize = child.calculateMaxReturnSize();
            childrenSum += maxReturnSize + child.calculateRetainedSizeAfterCallingNext();
            minChildReturnSize = Math.min(minChildReturnSize, maxReturnSize);
        }
        return childrenSum - minChildReturnSize + (long)TSFileDescriptor.getInstance().getConfig().getMaxTsBlockLineNumber() * MAP_NODE_RETRAINED_SIZE;
    }

    private boolean empty(int columnIndex) {
        return this.inputTsBlocks[columnIndex] == null || this.inputTsBlocks[columnIndex].getPositionCount() == this.inputIndex[columnIndex];
    }

    private void clearTsBlockCache(Binary endTimeSeries) {
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (this.empty(i) || this.comparator.compare(LastQueryUtil.getTimeSeries(this.inputTsBlocks[i], this.inputTsBlocks[i].getPositionCount() - 1), endTimeSeries) != 0) continue;
            this.inputTsBlocks[i] = null;
        }
    }

    private static class Location {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(Location.class).instanceSize();
        int tsBlockIndex;
        int rowIndex;

        public Location(int tsBlockIndex, int rowIndex) {
            this.tsBlockIndex = tsBlockIndex;
            this.rowIndex = rowIndex;
        }

        static /* synthetic */ int access$000() {
            return INSTANCE_SIZE;
        }
    }
}

