/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.ProcessOperator;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;

public class LimitOperator
implements ProcessOperator {
    private final OperatorContext operatorContext;
    private long remainingLimit;
    private final Operator child;

    public LimitOperator(OperatorContext operatorContext, long limit, Operator child) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        Preconditions.checkArgument((limit >= 0L ? 1 : 0) != 0, (Object)"limit must be at least zero");
        this.remainingLimit = limit;
        this.child = Objects.requireNonNull(child, "child operator is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.child.isBlocked();
    }

    @Override
    public TsBlock next() {
        TsBlock block = this.child.next();
        if (block == null) {
            return null;
        }
        TsBlock res = block;
        if ((long)block.getPositionCount() <= this.remainingLimit) {
            this.remainingLimit -= (long)block.getPositionCount();
        } else {
            res = block.getRegion(0, (int)this.remainingLimit);
            this.remainingLimit = 0L;
        }
        return res;
    }

    @Override
    public boolean hasNext() {
        return this.remainingLimit > 0L && this.child.hasNext();
    }

    @Override
    public void close() throws Exception {
        this.child.close();
    }

    @Override
    public boolean isFinished() {
        return this.remainingLimit == 0L || this.child.isFinished();
    }

    @Override
    public long calculateMaxPeekMemory() {
        return this.child.calculateMaxPeekMemory();
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.child.calculateMaxReturnSize();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.child.calculateRetainedSizeAfterCallingNext();
    }
}

