/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.executor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.common.response.ConsensusWriteResponse;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.consensus.DataRegionConsensusImpl;
import org.apache.iotdb.db.consensus.SchemaRegionConsensusImpl;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.metadata.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.metadata.schemaregion.SchemaEngine;
import org.apache.iotdb.db.mpp.execution.executor.RegionExecutionResult;
import org.apache.iotdb.db.mpp.plan.analyze.SchemaValidator;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.CreateAlignedTimeSeriesNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.CreateMultiTimeSeriesNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.CreateTimeSeriesNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.InternalCreateTimeSeriesNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.MeasurementGroup;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.DeleteDataNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertMultiTabletsNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertRowsOfOneDeviceNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.service.thrift.impl.DataNodeRegionManager;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionWriteExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegionWriteExecutor.class);
    private static final DataNodeRegionManager REGION_MANAGER = DataNodeRegionManager.getInstance();

    public RegionExecutionResult execute(ConsensusGroupId groupId, PlanNode planNode) {
        WritePlanNodeExecutionContext context = new WritePlanNodeExecutionContext(groupId, REGION_MANAGER.getRegionLock(groupId));
        WritePlanNodeExecutionVisitor executionVisitor = new WritePlanNodeExecutionVisitor();
        return planNode.accept(executionVisitor, context);
    }

    private static class WritePlanNodeExecutionContext {
        private final ConsensusGroupId regionId;
        private final ReentrantReadWriteLock regionRWLock;

        WritePlanNodeExecutionContext(ConsensusGroupId regionId, ReentrantReadWriteLock regionRWLock) {
            this.regionId = regionId;
            this.regionRWLock = regionRWLock;
        }

        public ConsensusGroupId getRegionId() {
            return this.regionId;
        }

        public ReentrantReadWriteLock getRegionWriteValidationRWLock() {
            return this.regionRWLock;
        }
    }

    private static class WritePlanNodeExecutionVisitor
    extends PlanVisitor<RegionExecutionResult, WritePlanNodeExecutionContext> {
        private final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();

        private WritePlanNodeExecutionVisitor() {
        }

        @Override
        public RegionExecutionResult visitPlan(PlanNode node, WritePlanNodeExecutionContext context) {
            RegionExecutionResult response = new RegionExecutionResult();
            ConsensusWriteResponse writeResponse = this.executePlanNodeInConsensusLayer(context.getRegionId(), node);
            if (writeResponse.getStatus() != null) {
                response.setAccepted(TSStatusCode.SUCCESS_STATUS.getStatusCode() == writeResponse.getStatus().getCode());
                response.setMessage(writeResponse.getStatus().message);
                response.setStatus(writeResponse.getStatus());
            } else {
                LOGGER.error("Something wrong happened while calling consensus layer's write API.", (Throwable)writeResponse.getException());
                response.setAccepted(false);
                response.setMessage(writeResponse.getException().toString());
                response.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR));
            }
            return response;
        }

        private ConsensusWriteResponse executePlanNodeInConsensusLayer(ConsensusGroupId groupId, PlanNode planNode) {
            if (groupId instanceof DataRegionId) {
                return DataRegionConsensusImpl.getInstance().write(groupId, (IConsensusRequest)planNode);
            }
            return SchemaRegionConsensusImpl.getInstance().write(groupId, (IConsensusRequest)planNode);
        }

        @Override
        public RegionExecutionResult visitInsertRow(InsertRowNode node, WritePlanNodeExecutionContext context) {
            return this.executeDataInsert(node, context);
        }

        @Override
        public RegionExecutionResult visitInsertTablet(InsertTabletNode node, WritePlanNodeExecutionContext context) {
            return this.executeDataInsert(node, context);
        }

        @Override
        public RegionExecutionResult visitInsertRows(InsertRowsNode node, WritePlanNodeExecutionContext context) {
            return this.executeDataInsert(node, context);
        }

        @Override
        public RegionExecutionResult visitInsertMultiTablets(InsertMultiTabletsNode node, WritePlanNodeExecutionContext context) {
            return this.executeDataInsert(node, context);
        }

        @Override
        public RegionExecutionResult visitInsertRowsOfOneDevice(InsertRowsOfOneDeviceNode node, WritePlanNodeExecutionContext context) {
            return this.executeDataInsert(node, context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RegionExecutionResult executeDataInsert(InsertNode insertNode, WritePlanNodeExecutionContext context) {
            RegionExecutionResult response = new RegionExecutionResult();
            context.getRegionWriteValidationRWLock().readLock().lock();
            try {
                ConsensusWriteResponse writeResponse;
                try {
                    SchemaValidator.validate(insertNode);
                }
                catch (SemanticException e) {
                    Object ioTDBException;
                    response.setAccepted(false);
                    response.setMessage(e.getMessage());
                    if (e.getCause() instanceof IoTDBException) {
                        ioTDBException = (IoTDBException)e.getCause();
                        response.setStatus(RpcUtils.getStatus((int)ioTDBException.getErrorCode(), (String)ioTDBException.getMessage()));
                    } else {
                        response.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.METADATA_ERROR, (String)e.getMessage()));
                    }
                    ioTDBException = response;
                    context.getRegionWriteValidationRWLock().readLock().unlock();
                    return ioTDBException;
                }
                boolean hasFailedMeasurement = insertNode.hasFailedMeasurements();
                String partialInsertMessage = null;
                if (hasFailedMeasurement) {
                    partialInsertMessage = String.format("Fail to insert measurements %s caused by %s", insertNode.getFailedMeasurements(), insertNode.getFailedMessages());
                    LOGGER.warn(partialInsertMessage);
                }
                if ((writeResponse = DataRegionConsensusImpl.getInstance().write(context.getRegionId(), (IConsensusRequest)insertNode)).getStatus() != null) {
                    response.setAccepted(!hasFailedMeasurement && TSStatusCode.SUCCESS_STATUS.getStatusCode() == writeResponse.getStatus().getCode());
                    if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != writeResponse.getStatus().getCode()) {
                        response.setMessage(writeResponse.getStatus().message);
                        response.setStatus(writeResponse.getStatus());
                    } else if (hasFailedMeasurement) {
                        response.setMessage(partialInsertMessage);
                        response.setStatus(RpcUtils.getStatus((int)TSStatusCode.METADATA_ERROR.getStatusCode(), (String)partialInsertMessage));
                    } else {
                        response.setMessage(writeResponse.getStatus().message);
                    }
                } else {
                    LOGGER.error("Something wrong happened while calling consensus layer's write API.", (Throwable)writeResponse.getException());
                    response.setAccepted(false);
                    response.setMessage(writeResponse.getException().toString());
                    response.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.WRITE_PROCESS_ERROR, (String)writeResponse.getException().toString()));
                }
                RegionExecutionResult regionExecutionResult = response;
                return regionExecutionResult;
            }
            finally {
                context.getRegionWriteValidationRWLock().readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RegionExecutionResult visitDeleteData(DeleteDataNode node, WritePlanNodeExecutionContext context) {
            context.getRegionWriteValidationRWLock().writeLock().lock();
            try {
                RegionExecutionResult regionExecutionResult = (RegionExecutionResult)super.visitDeleteData(node, context);
                return regionExecutionResult;
            }
            finally {
                context.getRegionWriteValidationRWLock().writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RegionExecutionResult visitCreateTimeSeries(CreateTimeSeriesNode node, WritePlanNodeExecutionContext context) {
            ISchemaRegion schemaRegion = SchemaEngine.getInstance().getSchemaRegion((SchemaRegionId)context.getRegionId());
            if (this.config.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus")) {
                context.getRegionWriteValidationRWLock().writeLock().lock();
                try {
                    Map<Integer, MetadataException> failingMeasurementMap = schemaRegion.checkMeasurementExistence(node.getPath().getDevicePath(), Collections.singletonList(node.getPath().getMeasurement()), Collections.singletonList(node.getAlias()));
                    if (failingMeasurementMap.isEmpty()) {
                        RegionExecutionResult regionExecutionResult = (RegionExecutionResult)super.visitCreateTimeSeries(node, context);
                        return regionExecutionResult;
                    }
                    MetadataException metadataException = failingMeasurementMap.get(0);
                    LOGGER.error("Metadata error: ", (Throwable)metadataException);
                    RegionExecutionResult result = new RegionExecutionResult();
                    result.setAccepted(false);
                    result.setMessage(metadataException.getMessage());
                    result.setStatus(RpcUtils.getStatus((int)metadataException.getErrorCode(), (String)metadataException.getMessage()));
                    RegionExecutionResult regionExecutionResult = result;
                    return regionExecutionResult;
                }
                finally {
                    context.getRegionWriteValidationRWLock().writeLock().unlock();
                }
            }
            return (RegionExecutionResult)super.visitCreateTimeSeries(node, context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RegionExecutionResult visitCreateAlignedTimeSeries(CreateAlignedTimeSeriesNode node, WritePlanNodeExecutionContext context) {
            ISchemaRegion schemaRegion = SchemaEngine.getInstance().getSchemaRegion((SchemaRegionId)context.getRegionId());
            if (this.config.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus")) {
                context.getRegionWriteValidationRWLock().writeLock().lock();
                try {
                    Map<Integer, MetadataException> failingMeasurementMap = schemaRegion.checkMeasurementExistence(node.getDevicePath(), node.getMeasurements(), node.getAliasList());
                    if (failingMeasurementMap.isEmpty()) {
                        RegionExecutionResult regionExecutionResult = (RegionExecutionResult)super.visitCreateAlignedTimeSeries(node, context);
                        return regionExecutionResult;
                    }
                    MetadataException metadataException = failingMeasurementMap.get(0);
                    LOGGER.error("Metadata error: ", (Throwable)metadataException);
                    RegionExecutionResult result = new RegionExecutionResult();
                    result.setAccepted(false);
                    result.setMessage(metadataException.getMessage());
                    result.setStatus(RpcUtils.getStatus((int)metadataException.getErrorCode(), (String)metadataException.getMessage()));
                    RegionExecutionResult regionExecutionResult = result;
                    return regionExecutionResult;
                }
                finally {
                    context.getRegionWriteValidationRWLock().writeLock().unlock();
                }
            }
            return (RegionExecutionResult)super.visitCreateAlignedTimeSeries(node, context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RegionExecutionResult visitCreateMultiTimeSeries(CreateMultiTimeSeriesNode node, WritePlanNodeExecutionContext context) {
            ISchemaRegion schemaRegion = SchemaEngine.getInstance().getSchemaRegion((SchemaRegionId)context.getRegionId());
            if (this.config.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus")) {
                context.getRegionWriteValidationRWLock().writeLock().lock();
                try {
                    ArrayList<TSStatus> failingStatus = new ArrayList<TSStatus>();
                    Map<PartialPath, MeasurementGroup> measurementGroupMap = node.getMeasurementGroupMap();
                    ArrayList<PartialPath> emptyDeviceList = new ArrayList<PartialPath>();
                    for (Map.Entry<PartialPath, MeasurementGroup> entry : measurementGroupMap.entrySet()) {
                        Map<Integer, MetadataException> failingMeasurementMap = schemaRegion.checkMeasurementExistence(entry.getKey(), entry.getValue().getMeasurements(), entry.getValue().getAliasList());
                        if (failingMeasurementMap.isEmpty()) continue;
                        for (Map.Entry<Integer, MetadataException> failingMeasurement : failingMeasurementMap.entrySet()) {
                            entry.getValue().removeMeasurement(failingMeasurement.getKey());
                            LOGGER.error("Metadata error: ", (Throwable)failingMeasurement.getValue());
                            failingStatus.add(RpcUtils.getStatus((int)failingMeasurement.getValue().getErrorCode(), (String)failingMeasurement.getValue().getMessage()));
                        }
                        if (!entry.getValue().isEmpty()) continue;
                        emptyDeviceList.add(entry.getKey());
                    }
                    for (Object emptyDevice : emptyDeviceList) {
                        measurementGroupMap.remove(emptyDevice);
                    }
                    if (!measurementGroupMap.isEmpty()) {
                        RegionExecutionResult executionResult = (RegionExecutionResult)super.visitCreateMultiTimeSeries(node, context);
                        if (failingStatus.isEmpty()) {
                            Object emptyDevice;
                            emptyDevice = executionResult;
                            return emptyDevice;
                        }
                        TSStatus executionStatus = executionResult.getStatus();
                        if (executionStatus.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                            failingStatus.addAll(executionStatus.getSubStatus());
                        } else if (executionStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                            failingStatus.add(executionStatus);
                        }
                    }
                    TSStatus status = RpcUtils.getStatus(failingStatus);
                    RegionExecutionResult failingResult = new RegionExecutionResult();
                    failingResult.setAccepted(false);
                    failingResult.setMessage(status.getMessage());
                    failingResult.setStatus(status);
                    RegionExecutionResult regionExecutionResult = failingResult;
                    return regionExecutionResult;
                }
                finally {
                    context.getRegionWriteValidationRWLock().writeLock().unlock();
                }
            }
            return (RegionExecutionResult)super.visitCreateMultiTimeSeries(node, context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RegionExecutionResult visitInternalCreateTimeSeries(InternalCreateTimeSeriesNode node, WritePlanNodeExecutionContext context) {
            ISchemaRegion schemaRegion = SchemaEngine.getInstance().getSchemaRegion((SchemaRegionId)context.getRegionId());
            if (this.config.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus")) {
                context.getRegionWriteValidationRWLock().writeLock().lock();
                try {
                    ArrayList<TSStatus> failingStatus = new ArrayList<TSStatus>();
                    ArrayList<TSStatus> alreadyExistingStatus = new ArrayList<TSStatus>();
                    MeasurementGroup measurementGroup = node.getMeasurementGroup();
                    Map<Integer, MetadataException> failingMeasurementMap = schemaRegion.checkMeasurementExistence(node.getDevicePath(), measurementGroup.getMeasurements(), measurementGroup.getAliasList());
                    for (Map.Entry<Integer, MetadataException> failingMeasurement : failingMeasurementMap.entrySet()) {
                        MetadataException metadataException = failingMeasurement.getValue();
                        if (metadataException.getErrorCode() == TSStatusCode.MEASUREMENT_ALREADY_EXIST.getStatusCode()) {
                            LOGGER.info("There's no need to internal create timeseries. {}", (Object)((MetadataException)((Object)failingMeasurement.getValue())).getMessage());
                            alreadyExistingStatus.add(RpcUtils.getStatus((int)metadataException.getErrorCode(), (String)metadataException.getMessage()));
                        } else {
                            LOGGER.error("Metadata error: ", (Throwable)metadataException);
                            failingStatus.add(RpcUtils.getStatus((int)metadataException.getErrorCode(), (String)metadataException.getMessage()));
                        }
                        measurementGroup.removeMeasurement((Integer)failingMeasurement.getKey());
                    }
                    RegionExecutionResult executionResult = (RegionExecutionResult)super.visitInternalCreateTimeSeries(node, context);
                    if (failingStatus.isEmpty() && alreadyExistingStatus.isEmpty()) {
                        Map.Entry<Integer, MetadataException> failingMeasurement;
                        failingMeasurement = executionResult;
                        return failingMeasurement;
                    }
                    TSStatus executionStatus = executionResult.getStatus();
                    if (failingStatus.isEmpty()) {
                        if (executionStatus.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                            if (((TSStatus)executionStatus.getSubStatus().get(0)).getCode() == TSStatusCode.MEASUREMENT_ALREADY_EXIST.getStatusCode()) {
                                alreadyExistingStatus.addAll(executionStatus.getSubStatus());
                            } else {
                                failingStatus.addAll(executionStatus.getSubStatus());
                            }
                        } else if (executionStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                            failingStatus.add(executionStatus);
                        }
                    } else if (executionStatus.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                        if (((TSStatus)executionStatus.getSubStatus().get(0)).getCode() != TSStatusCode.MEASUREMENT_ALREADY_EXIST.getStatusCode()) {
                            failingStatus.addAll(executionStatus.getSubStatus());
                        }
                    } else if (executionStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                        failingStatus.add(executionStatus);
                    }
                    TSStatus status = failingStatus.isEmpty() ? RpcUtils.getStatus(failingStatus) : RpcUtils.getStatus(alreadyExistingStatus);
                    RegionExecutionResult result = new RegionExecutionResult();
                    result.setAccepted(false);
                    result.setMessage(status.getMessage());
                    result.setStatus(status);
                    RegionExecutionResult regionExecutionResult = result;
                    return regionExecutionResult;
                }
                finally {
                    context.getRegionWriteValidationRWLock().writeLock().unlock();
                }
            }
            return (RegionExecutionResult)super.visitInternalCreateTimeSeries(node, context);
        }
    }
}

