/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.aggregation.slidingwindow;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iotdb.db.mpp.aggregation.Accumulator;
import org.apache.iotdb.db.mpp.aggregation.Aggregator;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;

public abstract class SlidingWindowAggregator
extends Aggregator {
    protected Deque<PartialAggregationResult> deque = new LinkedList<PartialAggregationResult>();
    protected TimeRange curTimeRange;

    public SlidingWindowAggregator(Accumulator accumulator, List<InputLocation[]> inputLocationList, AggregationStep step) {
        super(accumulator, step, inputLocationList);
    }

    @Override
    public int processTsBlock(TsBlock tsBlock) {
        Preconditions.checkArgument((boolean)this.step.isInputPartial(), (Object)"Step in SlidingWindowAggregationOperator can only process partial result");
        TimeColumn timeColumn = tsBlock.getTimeColumn();
        Column[] valueColumn = new Column[((InputLocation[])this.inputLocationList.get(0)).length];
        for (int i = 0; i < ((InputLocation[])this.inputLocationList.get(0)).length; ++i) {
            InputLocation inputLocation = ((InputLocation[])this.inputLocationList.get(0))[i];
            Preconditions.checkArgument((inputLocation.getTsBlockIndex() == 0 ? 1 : 0) != 0, (Object)"SlidingWindowAggregationOperator can only process one tsBlock input.");
            valueColumn[i] = tsBlock.getColumn(inputLocation.getValueColumnIndex());
        }
        this.processPartialResult(new PartialAggregationResult(timeColumn, valueColumn));
        return 1;
    }

    @Override
    public void updateTimeRange(TimeRange curTimeRange) {
        this.curTimeRange = curTimeRange;
        this.evictingExpiredValue();
    }

    protected abstract void evictingExpiredValue();

    public abstract void processPartialResult(PartialAggregationResult var1);

    protected static class PartialAggregationResult {
        private final TimeColumn timeColumn;
        private final Column[] partialResultColumns;

        public PartialAggregationResult(TimeColumn timeColumn, Column[] partialResultColumns) {
            this.timeColumn = timeColumn;
            this.partialResultColumns = partialResultColumns;
        }

        public boolean isNull() {
            return this.partialResultColumns[0].isNull(0);
        }

        public long getTime() {
            return this.timeColumn.getLong(0);
        }

        public Column[] getPartialResult() {
            return this.partialResultColumns;
        }

        public List<TSDataType> getDataTypes() {
            return ((Stream)Arrays.stream(this.partialResultColumns).sequential()).map(Column::getDataType).collect(Collectors.toList());
        }

        public Column[] opposite() {
            List<TSDataType> dataTypes = this.getDataTypes();
            TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(dataTypes);
            ColumnBuilder[] columnBuilders = tsBlockBuilder.getValueColumnBuilders();
            Column[] results = new Column[this.partialResultColumns.length];
            for (int i = 0; i < this.partialResultColumns.length; ++i) {
                switch (dataTypes.get(i)) {
                    case INT32: {
                        columnBuilders[i].writeInt(this.partialResultColumns[i].getInt(0) * -1);
                        break;
                    }
                    case INT64: {
                        columnBuilders[i].writeLong(this.partialResultColumns[i].getLong(0) * -1L);
                        break;
                    }
                    case FLOAT: {
                        columnBuilders[i].writeFloat(this.partialResultColumns[i].getFloat(0) * -1.0f);
                        break;
                    }
                    case DOUBLE: {
                        columnBuilders[i].writeDouble(this.partialResultColumns[i].getDouble(0) * -1.0);
                        break;
                    }
                    case TEXT: 
                    case BOOLEAN: {
                        throw new UnSupportedDataTypeException(String.format("Unsupported data type in opposite : %s", dataTypes.get(i)));
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown data type: " + dataTypes.get(i));
                    }
                }
                results[i] = columnBuilders[i].build();
            }
            return results;
        }
    }
}

