/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.aggregation;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.mpp.aggregation.Accumulator;
import org.apache.iotdb.db.mpp.execution.operator.window.IWindow;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class FirstValueAccumulator
implements Accumulator {
    protected final TSDataType seriesDataType;
    protected boolean hasCandidateResult;
    protected TsPrimitiveType firstValue;
    protected long minTime = Long.MAX_VALUE;

    public FirstValueAccumulator(TSDataType seriesDataType) {
        this.seriesDataType = seriesDataType;
        this.firstValue = TsPrimitiveType.getByType((TSDataType)seriesDataType);
    }

    @Override
    public int addInput(Column[] column, IWindow curWindow) {
        switch (this.seriesDataType) {
            case INT32: {
                return this.addIntInput(column, curWindow);
            }
            case INT64: {
                return this.addLongInput(column, curWindow);
            }
            case FLOAT: {
                return this.addFloatInput(column, curWindow);
            }
            case DOUBLE: {
                return this.addDoubleInput(column, curWindow);
            }
            case TEXT: {
                return this.addBinaryInput(column, curWindow);
            }
            case BOOLEAN: {
                return this.addBooleanInput(column, curWindow);
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in FirstValue: %s", this.seriesDataType));
    }

    @Override
    public void addIntermediate(Column[] partialResult) {
        Preconditions.checkArgument((partialResult.length == 2 ? 1 : 0) != 0, (Object)"partialResult of FirstValue should be 2");
        if (partialResult[0].isNull(0)) {
            return;
        }
        switch (this.seriesDataType) {
            case INT32: {
                this.updateIntFirstValue(partialResult[0].getInt(0), partialResult[1].getLong(0));
                break;
            }
            case INT64: {
                this.updateLongFirstValue(partialResult[0].getLong(0), partialResult[1].getLong(0));
                break;
            }
            case FLOAT: {
                this.updateFloatFirstValue(partialResult[0].getFloat(0), partialResult[1].getLong(0));
                break;
            }
            case DOUBLE: {
                this.updateDoubleFirstValue(partialResult[0].getDouble(0), partialResult[1].getLong(0));
                break;
            }
            case TEXT: {
                this.updateBinaryFirstValue(partialResult[0].getBinary(0), partialResult[1].getLong(0));
                break;
            }
            case BOOLEAN: {
                this.updateBooleanFirstValue(partialResult[0].getBoolean(0), partialResult[1].getLong(0));
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in FirstValue: %s", this.seriesDataType));
            }
        }
    }

    @Override
    public void addStatistics(Statistics statistics) {
        if (statistics == null) {
            return;
        }
        switch (this.seriesDataType) {
            case INT32: {
                this.updateIntFirstValue((Integer)statistics.getFirstValue(), statistics.getStartTime());
                break;
            }
            case INT64: {
                this.updateLongFirstValue((Long)statistics.getFirstValue(), statistics.getStartTime());
                break;
            }
            case FLOAT: {
                this.updateFloatFirstValue(((Float)statistics.getFirstValue()).floatValue(), statistics.getStartTime());
                break;
            }
            case DOUBLE: {
                this.updateDoubleFirstValue((Double)statistics.getFirstValue(), statistics.getStartTime());
                break;
            }
            case TEXT: {
                this.updateBinaryFirstValue((Binary)statistics.getFirstValue(), statistics.getStartTime());
                break;
            }
            case BOOLEAN: {
                this.updateBooleanFirstValue((Boolean)statistics.getFirstValue(), statistics.getStartTime());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in FirstValue: %s", this.seriesDataType));
            }
        }
    }

    @Override
    public void setFinal(Column finalResult) {
        this.reset();
        this.hasCandidateResult = true;
        this.firstValue.setObject(finalResult.getObject(0));
    }

    @Override
    public void outputIntermediate(ColumnBuilder[] columnBuilders) {
        Preconditions.checkArgument((columnBuilders.length == 2 ? 1 : 0) != 0, (Object)"partialResult of FirstValue should be 2");
        if (!this.hasCandidateResult) {
            columnBuilders[0].appendNull();
            columnBuilders[1].appendNull();
            return;
        }
        switch (this.seriesDataType) {
            case INT32: {
                columnBuilders[0].writeInt(this.firstValue.getInt());
                break;
            }
            case INT64: {
                columnBuilders[0].writeLong(this.firstValue.getLong());
                break;
            }
            case FLOAT: {
                columnBuilders[0].writeFloat(this.firstValue.getFloat());
                break;
            }
            case DOUBLE: {
                columnBuilders[0].writeDouble(this.firstValue.getDouble());
                break;
            }
            case TEXT: {
                columnBuilders[0].writeBinary(this.firstValue.getBinary());
                break;
            }
            case BOOLEAN: {
                columnBuilders[0].writeBoolean(this.firstValue.getBoolean());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in Extreme: %s", this.seriesDataType));
            }
        }
        columnBuilders[1].writeLong(this.minTime);
    }

    @Override
    public void outputFinal(ColumnBuilder columnBuilder) {
        if (!this.hasCandidateResult) {
            columnBuilder.appendNull();
            return;
        }
        switch (this.seriesDataType) {
            case INT32: {
                columnBuilder.writeInt(this.firstValue.getInt());
                break;
            }
            case INT64: {
                columnBuilder.writeLong(this.firstValue.getLong());
                break;
            }
            case FLOAT: {
                columnBuilder.writeFloat(this.firstValue.getFloat());
                break;
            }
            case DOUBLE: {
                columnBuilder.writeDouble(this.firstValue.getDouble());
                break;
            }
            case TEXT: {
                columnBuilder.writeBinary(this.firstValue.getBinary());
                break;
            }
            case BOOLEAN: {
                columnBuilder.writeBoolean(this.firstValue.getBoolean());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in Extreme: %s", this.seriesDataType));
            }
        }
    }

    @Override
    public void reset() {
        this.hasCandidateResult = false;
        this.minTime = Long.MAX_VALUE;
        this.firstValue.reset();
    }

    @Override
    public boolean hasFinalResult() {
        return this.hasCandidateResult;
    }

    @Override
    public TSDataType[] getIntermediateType() {
        return new TSDataType[]{this.firstValue.getDataType(), TSDataType.INT64};
    }

    @Override
    public TSDataType getFinalType() {
        return this.firstValue.getDataType();
    }

    protected int addIntInput(Column[] column, IWindow curWindow) {
        int curPositionCount = column[0].getPositionCount();
        for (int i = 0; i < curPositionCount; ++i) {
            if (column[0].isNull(i)) continue;
            if (!curWindow.satisfy(column[0], i)) {
                return i;
            }
            curWindow.mergeOnePoint();
            if (column[2].isNull(i)) continue;
            this.updateIntFirstValue(column[2].getInt(i), column[1].getLong(i));
            return i;
        }
        return curPositionCount;
    }

    protected void updateIntFirstValue(int value, long curTime) {
        this.hasCandidateResult = true;
        if (curTime < this.minTime) {
            this.minTime = curTime;
            this.firstValue.setInt(value);
        }
    }

    protected int addLongInput(Column[] column, IWindow curWindow) {
        int curPositionCount = column[0].getPositionCount();
        for (int i = 0; i < curPositionCount; ++i) {
            if (column[0].isNull(i)) continue;
            if (!curWindow.satisfy(column[0], i)) {
                return i;
            }
            curWindow.mergeOnePoint();
            if (column[2].isNull(i)) continue;
            this.updateLongFirstValue(column[2].getLong(i), column[1].getLong(i));
            return i;
        }
        return curPositionCount;
    }

    protected void updateLongFirstValue(long value, long curTime) {
        this.hasCandidateResult = true;
        if (curTime < this.minTime) {
            this.minTime = curTime;
            this.firstValue.setLong(value);
        }
    }

    protected int addFloatInput(Column[] column, IWindow curWindow) {
        int curPositionCount = column[0].getPositionCount();
        for (int i = 0; i < curPositionCount; ++i) {
            if (column[0].isNull(i)) continue;
            if (!curWindow.satisfy(column[0], i)) {
                return i;
            }
            curWindow.mergeOnePoint();
            if (column[2].isNull(i)) continue;
            this.updateFloatFirstValue(column[2].getFloat(i), column[1].getLong(i));
            return i;
        }
        return curPositionCount;
    }

    protected void updateFloatFirstValue(float value, long curTime) {
        this.hasCandidateResult = true;
        if (curTime < this.minTime) {
            this.minTime = curTime;
            this.firstValue.setFloat(value);
        }
    }

    protected int addDoubleInput(Column[] column, IWindow curWindow) {
        int curPositionCount = column[0].getPositionCount();
        for (int i = 0; i < curPositionCount; ++i) {
            if (column[0].isNull(i)) continue;
            if (!curWindow.satisfy(column[0], i)) {
                return i;
            }
            curWindow.mergeOnePoint();
            if (column[2].isNull(i)) continue;
            this.updateDoubleFirstValue(column[2].getDouble(i), column[1].getLong(i));
            return i;
        }
        return curPositionCount;
    }

    protected void updateDoubleFirstValue(double value, long curTime) {
        this.hasCandidateResult = true;
        if (curTime < this.minTime) {
            this.minTime = curTime;
            this.firstValue.setDouble(value);
        }
    }

    protected int addBooleanInput(Column[] column, IWindow curWindow) {
        int curPositionCount = column[0].getPositionCount();
        for (int i = 0; i < curPositionCount; ++i) {
            if (column[0].isNull(i)) continue;
            if (!curWindow.satisfy(column[0], i)) {
                return i;
            }
            curWindow.mergeOnePoint();
            if (column[2].isNull(i)) continue;
            this.updateBooleanFirstValue(column[2].getBoolean(i), column[1].getLong(i));
            return i;
        }
        return curPositionCount;
    }

    protected void updateBooleanFirstValue(boolean value, long curTime) {
        this.hasCandidateResult = true;
        if (curTime < this.minTime) {
            this.minTime = curTime;
            this.firstValue.setBoolean(value);
        }
    }

    protected int addBinaryInput(Column[] column, IWindow curWindow) {
        int curPositionCount = column[0].getPositionCount();
        for (int i = 0; i < curPositionCount; ++i) {
            if (column[0].isNull(i)) continue;
            if (!curWindow.satisfy(column[0], i)) {
                return i;
            }
            curWindow.mergeOnePoint();
            if (column[2].isNull(i)) continue;
            this.updateBinaryFirstValue(column[2].getBinary(i), column[1].getLong(i));
            return i;
        }
        return curPositionCount;
    }

    protected void updateBinaryFirstValue(Binary value, long curTime) {
        this.hasCandidateResult = true;
        if (curTime < this.minTime) {
            this.minTime = curTime;
            this.firstValue.setBinary(value);
        }
    }
}

