/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.aggregation;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.mpp.aggregation.Accumulator;
import org.apache.iotdb.db.mpp.execution.operator.window.IWindow;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;

public class CountAccumulator
implements Accumulator {
    private long countValue = 0L;

    @Override
    public int addInput(Column[] column, IWindow curWindow) {
        int curPositionCount = column[0].getPositionCount();
        if (!column[2].mayHaveNull() && curWindow.contains(column[1])) {
            this.countValue += (long)curPositionCount;
        } else {
            for (int i = 0; i < curPositionCount; ++i) {
                if (column[0].isNull(i)) continue;
                if (!curWindow.satisfy(column[0], i)) {
                    return i;
                }
                curWindow.mergeOnePoint();
                if (column[2].isNull(i)) continue;
                ++this.countValue;
            }
        }
        return curPositionCount;
    }

    @Override
    public void addIntermediate(Column[] partialResult) {
        Preconditions.checkArgument((partialResult.length == 1 ? 1 : 0) != 0, (Object)"partialResult of Count should be 1");
        if (partialResult[0].isNull(0)) {
            return;
        }
        this.countValue += partialResult[0].getLong(0);
    }

    @Override
    public void addStatistics(Statistics statistics) {
        if (statistics == null) {
            return;
        }
        this.countValue += statistics.getCount();
    }

    @Override
    public void setFinal(Column finalResult) {
        if (finalResult.isNull(0)) {
            return;
        }
        this.countValue = finalResult.getLong(0);
    }

    @Override
    public void outputIntermediate(ColumnBuilder[] columnBuilders) {
        Preconditions.checkArgument((columnBuilders.length == 1 ? 1 : 0) != 0, (Object)"partialResult of Count should be 1");
        columnBuilders[0].writeLong(this.countValue);
    }

    @Override
    public void outputFinal(ColumnBuilder columnBuilder) {
        columnBuilder.writeLong(this.countValue);
    }

    @Override
    public void reset() {
        this.countValue = 0L;
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public TSDataType[] getIntermediateType() {
        return new TSDataType[]{TSDataType.INT64};
    }

    @Override
    public TSDataType getFinalType() {
        return TSDataType.INT64;
    }
}

