/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.traverser.collector;

import java.util.HashSet;
import java.util.Set;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mtree.store.IMTreeStore;
import org.apache.iotdb.db.metadata.mtree.traverser.collector.MNodeCollector;

public abstract class MNodeAboveSGCollector<T>
extends MNodeCollector<T> {
    protected Set<PartialPath> involvedStorageGroupMNodes = new HashSet<PartialPath>();

    public MNodeAboveSGCollector(IMNode startNode, PartialPath path, IMTreeStore store) throws MetadataException {
        super(startNode, path, store);
    }

    @Override
    protected boolean processInternalMatchedMNode(IMNode node, int idx, int level) {
        boolean shouldSkipSubtree = super.processInternalMatchedMNode(node, idx, level);
        if (node.isStorageGroup()) {
            this.involvedStorageGroupMNodes.add(node.getPartialPath());
            return true;
        }
        return shouldSkipSubtree;
    }

    @Override
    protected boolean processFullMatchedMNode(IMNode node, int idx, int level) {
        boolean shouldSkipSubtree = super.processFullMatchedMNode(node, idx, level);
        if (node.isStorageGroup()) {
            this.involvedStorageGroupMNodes.add(node.getPartialPath());
            return true;
        }
        return shouldSkipSubtree;
    }

    public Set<PartialPath> getInvolvedStorageGroupMNodes() {
        return this.involvedStorageGroupMNodes;
    }
}

