/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.store.disk.memcontrol;

import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.estimator.BasicMNodSizeEstimator;

public class CachedMNodeSizeEstimator
extends BasicMNodSizeEstimator {
    private static final int CACHE_ENTRY_SIZE = 40;
    private static final int CACHED_MNODE_CONTAINER_SIZE_DELTA = 192;
    private static final int NODE_BASE_SIZE = 140;
    private static final int INTERNAL_NODE_BASE_SIZE = 289;

    @Override
    public int estimateSize(IMNode node) {
        int size = 140 + node.getName().length();
        if (node.isMeasurement()) {
            size += 56;
            IMeasurementMNode measurementMNode = node.getAsMeasurementMNode();
            if (measurementMNode.getAlias() != null) {
                size += 52 + measurementMNode.getAlias().length();
            }
        } else {
            size += 289;
            if (node.isStorageGroup()) {
                size += 16;
                size += node.getAsStorageGroupMNode().getFullPath().length();
            }
            if (node.isEntity()) {
                size += 17;
            }
        }
        return size;
    }
}

