/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mnode;

import java.io.IOException;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchema;
import org.apache.iotdb.db.metadata.logfile.MLogWriter;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.metadata.mnode.InternalMNode;
import org.apache.iotdb.db.metadata.mnode.MNodeType;
import org.apache.iotdb.db.metadata.mnode.visitor.MNodeVisitor;
import org.apache.iotdb.db.qp.physical.sys.StorageGroupMNodePlan;

public class StorageGroupMNode
extends InternalMNode
implements IStorageGroupMNode {
    private static final long serialVersionUID = 7999036474525817732L;
    private TStorageGroupSchema schema;

    public StorageGroupMNode(IMNode parent, String name) {
        super(parent, name);
    }

    public StorageGroupMNode(IMNode parent, String name, long dataTTL) {
        super(parent, name);
        this.schema = new TStorageGroupSchema(name).setTTL(dataTTL);
    }

    @Override
    public String getFullPath() {
        if (this.fullPath == null) {
            this.fullPath = this.concatFullPath().intern();
        }
        return this.fullPath;
    }

    @Override
    public long getDataTTL() {
        return this.schema.getTTL();
    }

    @Override
    public void setDataTTL(long dataTTL) {
        this.schema.setTTL(dataTTL);
    }

    @Override
    public void setSchemaReplicationFactor(int schemaReplicationFactor) {
        this.schema.setSchemaReplicationFactor(schemaReplicationFactor);
    }

    @Override
    public void setDataReplicationFactor(int dataReplicationFactor) {
        this.schema.setDataReplicationFactor(dataReplicationFactor);
    }

    @Override
    public void setTimePartitionInterval(long timePartitionInterval) {
        this.schema.setTimePartitionInterval(timePartitionInterval);
    }

    @Override
    public void setStorageGroupSchema(TStorageGroupSchema schema) {
        this.schema = schema;
    }

    @Override
    public TStorageGroupSchema getStorageGroupSchema() {
        return this.schema;
    }

    @Override
    public void moveDataToNewMNode(IMNode newMNode) {
        super.moveDataToNewMNode(newMNode);
    }

    @Override
    public boolean isStorageGroup() {
        return true;
    }

    @Override
    public MNodeType getMNodeType(Boolean isConfig) {
        return MNodeType.STORAGE_GROUP;
    }

    @Override
    public void serializeTo(MLogWriter logWriter) throws IOException {
        this.serializeChildren(logWriter);
        logWriter.serializeStorageGroupMNode(this);
    }

    public static StorageGroupMNode deserializeFrom(StorageGroupMNodePlan plan) {
        return new StorageGroupMNode(null, plan.getName(), plan.getDataTTL());
    }

    public static StorageGroupMNode deserializeFrom(String[] nodeInfo) {
        return new StorageGroupMNode(null, nodeInfo[1], Long.parseLong(nodeInfo[2]));
    }

    @Override
    public <R, C> R accept(MNodeVisitor<R, C> visitor, C context) {
        return visitor.visitStorageGroupMNode(this, context);
    }
}

