/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup.dataregion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.storagegroup.DataRegion;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.dataregion.HashVirtualPartitioner;
import org.apache.iotdb.db.engine.storagegroup.dataregion.VirtualPartitioner;
import org.apache.iotdb.db.exception.DataRegionException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.StorageGroupNotReadyException;
import org.apache.iotdb.db.exception.TsFileProcessorException;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.utils.ThreadUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageGroupManager {
    private static final Logger logger = LoggerFactory.getLogger(StorageGroupManager.class);
    VirtualPartitioner partitioner = HashVirtualPartitioner.getInstance();
    DataRegion[] dataRegion;
    private final AtomicBoolean[] isDataRegionReady;
    private AtomicInteger readyDataRegionNum;
    private final AtomicBoolean isSettling = new AtomicBoolean();
    private long monitorSeriesValue;

    public StorageGroupManager() {
        this(false);
    }

    public StorageGroupManager(boolean needRecovering) {
        this.dataRegion = new DataRegion[this.partitioner.getPartitionCount()];
        this.isDataRegionReady = new AtomicBoolean[this.partitioner.getPartitionCount()];
        boolean recoverReady = !needRecovering;
        for (int i = 0; i < this.partitioner.getPartitionCount(); ++i) {
            this.isDataRegionReady[i] = new AtomicBoolean(recoverReady);
        }
    }

    public void forceCloseAllWorkingTsFileProcessors() throws TsFileProcessorException {
        for (DataRegion dataRegion : this.dataRegion) {
            if (dataRegion == null) continue;
            dataRegion.forceCloseAllWorkingTsFileProcessors();
        }
    }

    public void syncCloseAllWorkingTsFileProcessors() {
        for (DataRegion dataRegion : this.dataRegion) {
            if (dataRegion == null) continue;
            dataRegion.syncCloseAllWorkingTsFileProcessors();
        }
    }

    public void checkTTL() {
        for (DataRegion dataRegion : this.dataRegion) {
            if (dataRegion == null) continue;
            dataRegion.checkFilesTTL();
        }
    }

    public void timedFlushSeqMemTable() {
        for (DataRegion dataRegion : this.dataRegion) {
            if (dataRegion == null) continue;
            dataRegion.timedFlushSeqMemTable();
        }
    }

    public void timedFlushUnseqMemTable() {
        for (DataRegion dataRegion : this.dataRegion) {
            if (dataRegion == null) continue;
            dataRegion.timedFlushUnseqMemTable();
        }
    }

    public DataRegion getProcessor(PartialPath partialPath, IStorageGroupMNode storageGroupMNode) throws DataRegionException, StorageEngineException {
        int dataRegionId = this.partitioner.deviceToDataRegionId(partialPath);
        return this.getProcessor(storageGroupMNode, dataRegionId);
    }

    public DataRegion getProcessor(int dataRegionId, IStorageGroupMNode storageGroupMNode) throws DataRegionException, StorageEngineException {
        return this.getProcessor(storageGroupMNode, dataRegionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataRegion getProcessor(IStorageGroupMNode storageGroupMNode, int dataRegionId) throws DataRegionException, StorageEngineException {
        DataRegion processor = this.dataRegion[dataRegionId];
        if (processor == null) {
            if (this.isDataRegionReady[dataRegionId].get()) {
                AtomicBoolean atomicBoolean = this.isDataRegionReady[dataRegionId];
                synchronized (atomicBoolean) {
                    processor = this.dataRegion[dataRegionId];
                    if (processor == null) {
                        this.dataRegion[dataRegionId] = processor = StorageEngine.getInstance().buildNewStorageGroupProcessor(storageGroupMNode.getPartialPath(), storageGroupMNode, String.valueOf(dataRegionId));
                    }
                }
            } else {
                throw new StorageGroupNotReadyException(storageGroupMNode.getFullPath(), TSStatusCode.STORAGE_GROUP_NOT_READY.getStatusCode());
            }
        }
        return processor;
    }

    public void asyncRecover(IStorageGroupMNode storageGroupMNode, ExecutorService pool, List<Future<Void>> futures) {
        this.readyDataRegionNum = new AtomicInteger(0);
        int i = 0;
        while (i < this.partitioner.getPartitionCount()) {
            int cur = i++;
            Callable<Void> recoverVsgTask = () -> {
                this.isDataRegionReady[cur].set(false);
                DataRegion processor = null;
                try {
                    processor = StorageEngine.getInstance().buildNewStorageGroupProcessor(storageGroupMNode.getPartialPath(), storageGroupMNode, String.valueOf(cur));
                }
                catch (DataRegionException e) {
                    logger.error("Failed to recover virtual storage group {}[{}]", new Object[]{storageGroupMNode.getFullPath(), cur, e});
                }
                this.dataRegion[cur] = processor;
                this.isDataRegionReady[cur].set(true);
                logger.info("Storage Group {} has been recovered {}/{}", new Object[]{storageGroupMNode.getFullPath(), this.readyDataRegionNum.incrementAndGet(), this.partitioner.getPartitionCount()});
                return null;
            };
            futures.add(pool.submit(recoverVsgTask));
        }
    }

    public long getMonitorSeriesValue() {
        return this.monitorSeriesValue;
    }

    public void setMonitorSeriesValue(long monitorSeriesValue) {
        this.monitorSeriesValue = monitorSeriesValue;
    }

    public void updateMonitorSeriesValue(int successPointsNum) {
        this.monitorSeriesValue += (long)successPointsNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeStorageGroupProcessor(boolean isSeq, boolean isSync) {
        for (DataRegion processor : this.dataRegion) {
            if (processor == null) continue;
            if (logger.isInfoEnabled()) {
                logger.info("{} closing sg processor is called for closing {}, seq = {}", new Object[]{isSync ? "sync" : "async", processor.getDataRegionId() + "-" + processor.getStorageGroupName(), isSeq});
            }
            processor.writeLock("VirtualCloseStorageGroupProcessor-204");
            try {
                if (isSeq) {
                    for (TsFileProcessor tsfileProcessor : new ArrayList<TsFileProcessor>(processor.getWorkSequenceTsFileProcessors())) {
                        if (isSync) {
                            processor.syncCloseOneTsFileProcessor(true, tsfileProcessor);
                            continue;
                        }
                        processor.asyncCloseOneTsFileProcessor(true, tsfileProcessor);
                    }
                    continue;
                }
                for (TsFileProcessor tsfileProcessor : new ArrayList<TsFileProcessor>(processor.getWorkUnsequenceTsFileProcessors())) {
                    if (isSync) {
                        processor.syncCloseOneTsFileProcessor(false, tsfileProcessor);
                        continue;
                    }
                    processor.asyncCloseOneTsFileProcessor(false, tsfileProcessor);
                }
            }
            finally {
                processor.writeUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeStorageGroupProcessor(long partitionId, boolean isSeq, boolean isSync) {
        block3: for (DataRegion processor : this.dataRegion) {
            if (processor == null) continue;
            logger.info("async closing sg processor is called for closing {}, seq = {}, partitionId = {}", new Object[]{processor.getDataRegionId() + "-" + processor.getStorageGroupName(), isSeq, partitionId});
            processor.writeLock("VirtualCloseStorageGroupProcessor-242");
            try {
                ArrayList<TsFileProcessor> processors = isSeq ? new ArrayList<TsFileProcessor>(processor.getWorkSequenceTsFileProcessors()) : new ArrayList<TsFileProcessor>(processor.getWorkUnsequenceTsFileProcessors());
                for (TsFileProcessor tsfileProcessor : processors) {
                    if (tsfileProcessor.getTimeRangeId() != partitionId) continue;
                    if (isSync) {
                        processor.syncCloseOneTsFileProcessor(isSeq, tsfileProcessor);
                        continue block3;
                    }
                    processor.asyncCloseOneTsFileProcessor(isSeq, tsfileProcessor);
                    continue block3;
                }
            }
            finally {
                processor.writeUnlock();
            }
        }
    }

    public void delete(PartialPath path, long startTime, long endTime, long planIndex, DataRegion.TimePartitionFilter timePartitionFilter) throws IOException {
        for (DataRegion dataRegion : this.dataRegion) {
            if (dataRegion == null) continue;
            dataRegion.delete(path, startTime, endTime, planIndex, timePartitionFilter);
        }
    }

    public int countUpgradeFiles() {
        int totalUpgradeFileNum = 0;
        for (DataRegion dataRegion : this.dataRegion) {
            if (dataRegion == null) continue;
            totalUpgradeFileNum += dataRegion.countUpgradeFiles();
        }
        return totalUpgradeFileNum;
    }

    public void upgradeAll() {
        for (DataRegion dataRegion : this.dataRegion) {
            if (dataRegion == null) continue;
            dataRegion.upgrade();
        }
    }

    public void getResourcesToBeSettled(List<TsFileResource> seqResourcesToBeSettled, List<TsFileResource> unseqResourcesToBeSettled, List<String> tsFilePaths) {
        for (DataRegion dataRegion : this.dataRegion) {
            if (dataRegion == null) continue;
            dataRegion.addSettleFilesToList(seqResourcesToBeSettled, unseqResourcesToBeSettled, tsFilePaths);
        }
    }

    public void mergeAll() {
        for (DataRegion dataRegion : this.dataRegion) {
            if (dataRegion == null) continue;
            dataRegion.compact();
        }
    }

    public void syncDeleteDataFiles() {
        for (DataRegion dataRegion : this.dataRegion) {
            if (dataRegion == null) continue;
            dataRegion.syncDeleteDataFiles();
        }
    }

    public void setTTL(long dataTTL) {
        for (DataRegion dataRegion : this.dataRegion) {
            if (dataRegion == null) continue;
            dataRegion.setDataTTLWithTimePrecisionCheck(dataTTL);
        }
    }

    public void deleteStorageGroupSystemFolder(String systemDir) {
        for (DataRegion processor : this.dataRegion) {
            if (processor == null) continue;
            processor.deleteFolder(systemDir);
        }
    }

    public void getAllClosedStorageGroupTsFile(PartialPath storageGroupName, Map<PartialPath, Map<Long, List<TsFileResource>>> ret) {
        for (DataRegion dataRegion : this.dataRegion) {
            if (dataRegion == null) continue;
            List<TsFileResource> allResources = dataRegion.getSequenceFileList();
            allResources.addAll(dataRegion.getUnSequenceFileList());
            for (TsFileResource tsfile : allResources) {
                if (!tsfile.isClosed()) continue;
                long partitionNum = tsfile.getTimePartition();
                Map storageGroupFiles = ret.computeIfAbsent(storageGroupName, n -> new HashMap());
                storageGroupFiles.computeIfAbsent(partitionNum, n -> new ArrayList()).add(tsfile);
            }
        }
    }

    public void setPartitionVersionToMax(long partitionId, long newMaxVersion) {
        for (DataRegion dataRegion : this.dataRegion) {
            if (dataRegion == null) continue;
            dataRegion.setPartitionFileVersionToMax(partitionId, newMaxVersion);
        }
    }

    public void removePartitions(DataRegion.TimePartitionFilter filter) {
        for (DataRegion dataRegion : this.dataRegion) {
            if (dataRegion == null) continue;
            dataRegion.removePartitions(filter);
        }
    }

    public void getWorkingStorageGroupPartitions(String storageGroupName, Map<String, List<Pair<Long, Boolean>>> res) {
        for (DataRegion dataRegion : this.dataRegion) {
            Pair tmpPair;
            if (dataRegion == null) continue;
            ArrayList<Pair> partitionIdList = new ArrayList<Pair>();
            for (TsFileProcessor tsFileProcessor : dataRegion.getWorkSequenceTsFileProcessors()) {
                tmpPair = new Pair((Object)tsFileProcessor.getTimeRangeId(), (Object)true);
                partitionIdList.add(tmpPair);
            }
            for (TsFileProcessor tsFileProcessor : dataRegion.getWorkUnsequenceTsFileProcessors()) {
                tmpPair = new Pair((Object)tsFileProcessor.getTimeRangeId(), (Object)false);
                partitionIdList.add(tmpPair);
            }
            res.put(storageGroupName, partitionIdList);
        }
    }

    public void reset() {
        Arrays.fill(this.dataRegion, null);
    }

    public void stopSchedulerPool() {
        for (DataRegion vsg : this.dataRegion) {
            if (vsg == null) continue;
            ThreadUtils.stopThreadPool(vsg.getTimedCompactionScheduleTask(), ThreadName.COMPACTION_SCHEDULE);
        }
    }

    public void setSettling(boolean settling) {
        this.isSettling.set(settling);
    }

    public void setAllowCompaction(boolean allowCompaction) {
        for (DataRegion processor : this.dataRegion) {
            if (processor == null) continue;
            processor.setAllowCompaction(allowCompaction);
        }
    }

    public void abortCompaction() {
        for (DataRegion processor : this.dataRegion) {
            if (processor == null) continue;
            processor.abortCompaction();
        }
    }

    public AtomicBoolean getIsSettling() {
        return this.isSettling;
    }
}

