/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.load;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.db.engine.load.ChunkData;
import org.apache.iotdb.db.utils.TimePartitionUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.exception.write.PageException;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.reader.page.PageReader;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;

public class NonAlignedChunkData
implements ChunkData {
    private long offset;
    private long dataSize;
    private boolean isHeadPageNeedDecode;
    private boolean isTailPageNeedDecode;
    private TTimePartitionSlot timePartitionSlot;
    private String device;
    private ChunkHeader chunkHeader;
    private IChunkMetadata chunkMetadata;
    private ChunkWriterImpl chunkWriter;
    private Chunk chunk;

    public NonAlignedChunkData(long offset, String device, ChunkHeader chunkHeader) {
        this.offset = offset;
        this.dataSize = 0L;
        this.isHeadPageNeedDecode = false;
        this.isTailPageNeedDecode = false;
        this.device = device;
        this.chunkHeader = chunkHeader;
    }

    @Override
    public String getDevice() {
        return this.device;
    }

    @Override
    public TTimePartitionSlot getTimePartitionSlot() {
        return this.timePartitionSlot;
    }

    @Override
    public long getDataSize() {
        return this.dataSize;
    }

    @Override
    public void addDataSize(long pageSize) {
        this.dataSize += pageSize;
    }

    @Override
    public void setNotDecode(IChunkMetadata chunkMetadata) {
        this.chunkMetadata = chunkMetadata;
    }

    @Override
    public boolean needDecodeChunk() {
        return this.chunkMetadata == null;
    }

    @Override
    public void setHeadPageNeedDecode(boolean headPageNeedDecode) {
        this.isHeadPageNeedDecode = headPageNeedDecode;
    }

    @Override
    public void setTailPageNeedDecode(boolean tailPageNeedDecode) {
        this.isTailPageNeedDecode = tailPageNeedDecode;
    }

    @Override
    public void setTimePartitionSlot(TTimePartitionSlot timePartitionSlot) {
        this.timePartitionSlot = timePartitionSlot;
    }

    @Override
    public boolean isAligned() {
        return false;
    }

    @Override
    public void writeToFileWriter(TsFileIOWriter writer) throws IOException {
        if (this.chunk != null) {
            writer.writeChunk(this.chunk);
        } else {
            this.chunkWriter.writeToFileWriter(writer);
        }
    }

    @Override
    public void serialize(DataOutputStream stream, File tsFile) throws IOException {
        ReadWriteIOUtils.write((Boolean)this.isAligned(), (OutputStream)stream);
        this.serializeAttr(stream);
        if (this.needDecodeChunk()) {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            this.serializeDecodeChunk(stream, tsFile);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
            this.serializeEntireChunk(stream, tsFile);
        }
    }

    private void serializeAttr(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((long)this.timePartitionSlot.getStartTime(), (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.device, (OutputStream)stream);
        this.chunkHeader.serializeTo((OutputStream)stream);
    }

    private void serializeEntireChunk(DataOutputStream stream, File tsFile) throws IOException {
        try (TsFileSequenceReader reader = new TsFileSequenceReader(tsFile.getAbsolutePath());){
            ByteBuffer chunkData = reader.readChunk(this.chunkMetadata.getOffsetOfChunkHeader() + (long)this.chunkHeader.getSerializedSize(), this.chunkHeader.getDataSize());
            ReadWriteIOUtils.write((ByteBuffer)chunkData, (OutputStream)stream);
            this.chunkMetadata.getStatistics().serialize((OutputStream)stream);
        }
    }

    private void serializeDecodeChunk(DataOutputStream stream, File tsFile) throws IOException {
        try (TsFileSequenceReader reader = new TsFileSequenceReader(tsFile.getAbsolutePath());){
            long pageDataSize;
            Decoder defaultTimeDecoder = Decoder.getDecoderByType((TSEncoding)TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), (TSDataType)TSDataType.INT64);
            Decoder valueDecoder = Decoder.getDecoderByType((TSEncoding)this.chunkHeader.getEncodingType(), (TSDataType)this.chunkHeader.getDataType());
            reader.position(this.offset);
            for (long dataSize = this.dataSize; dataSize > 0L; dataSize -= pageDataSize) {
                boolean hasStatistic = (this.chunkHeader.getChunkType() & 0x3F) == 1;
                PageHeader pageHeader = reader.readPageHeader(this.chunkHeader.getDataType(), hasStatistic);
                pageDataSize = pageHeader.getSerializedPageSize();
                if (dataSize == this.dataSize && this.isHeadPageNeedDecode || dataSize == pageDataSize && this.isTailPageNeedDecode) {
                    ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
                    this.decodePage(reader, pageHeader, defaultTimeDecoder, valueDecoder, stream);
                    continue;
                }
                ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
                pageHeader.serializeTo((OutputStream)stream);
                ByteBuffer pageData = reader.readCompressedPage(pageHeader);
                ReadWriteIOUtils.write((ByteBuffer)pageData, (OutputStream)stream);
            }
        }
        ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
        ReadWriteIOUtils.write((int)-1, (OutputStream)stream);
    }

    private void decodePage(TsFileSequenceReader reader, PageHeader pageHeader, Decoder timeDecoder, Decoder valueDecoder, DataOutputStream stream) throws IOException {
        long time;
        valueDecoder.reset();
        ByteBuffer pageData = reader.readPage(pageHeader, this.chunkHeader.getCompressionType());
        PageReader pageReader = new PageReader(pageData, this.chunkHeader.getDataType(), valueDecoder, timeDecoder, null);
        BatchData batchData = pageReader.getAllSatisfiedPageData();
        int length = 0;
        while (batchData.hasCurrent()) {
            time = batchData.currentTime();
            if (time < this.timePartitionSlot.getStartTime()) {
                batchData.next();
                continue;
            }
            if (!this.timePartitionSlot.equals(TimePartitionUtils.getTimePartitionForRouting(time))) break;
            ++length;
            batchData.next();
        }
        ReadWriteIOUtils.write((int)length, (OutputStream)stream);
        batchData.resetBatchData();
        while (batchData.hasCurrent()) {
            time = batchData.currentTime();
            if (time < this.timePartitionSlot.getStartTime()) {
                batchData.next();
                continue;
            }
            if (!this.timePartitionSlot.equals(TimePartitionUtils.getTimePartitionForRouting(time))) break;
            ReadWriteIOUtils.write((long)time, (OutputStream)stream);
            Object value = batchData.currentValue();
            switch (this.chunkHeader.getDataType()) {
                case INT32: {
                    ReadWriteIOUtils.write((int)((Integer)value), (OutputStream)stream);
                    break;
                }
                case INT64: {
                    ReadWriteIOUtils.write((long)((Long)value), (OutputStream)stream);
                    break;
                }
                case FLOAT: {
                    ReadWriteIOUtils.write((float)((Float)value).floatValue(), (OutputStream)stream);
                    break;
                }
                case DOUBLE: {
                    ReadWriteIOUtils.write((double)((Double)value), (OutputStream)stream);
                    break;
                }
                case BOOLEAN: {
                    ReadWriteIOUtils.write((Boolean)((Boolean)value), (OutputStream)stream);
                    break;
                }
                case TEXT: {
                    ReadWriteIOUtils.write((Binary)((Binary)value), (OutputStream)stream);
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", this.chunkHeader.getDataType()));
                }
            }
            batchData.next();
        }
    }

    private void deserializeTsFileData(InputStream stream) throws IOException, PageException {
        boolean needDecodeChunk = ReadWriteIOUtils.readBool((InputStream)stream);
        if (needDecodeChunk) {
            this.buildChunkWriter(stream);
        } else {
            this.deserializeEntireChunk(stream);
        }
    }

    private void buildChunkWriter(InputStream stream) throws IOException, PageException {
        this.chunkWriter = new ChunkWriterImpl((IMeasurementSchema)new MeasurementSchema(this.chunkHeader.getMeasurementID(), this.chunkHeader.getDataType(), this.chunkHeader.getEncodingType(), this.chunkHeader.getCompressionType()));
        while (true) {
            boolean needDecode;
            if (needDecode = ReadWriteIOUtils.readBool((InputStream)stream)) {
                int length = ReadWriteIOUtils.readInt((InputStream)stream);
                if (length == -1) break;
                block9: for (int i = 0; i < length; ++i) {
                    long time = ReadWriteIOUtils.readLong((InputStream)stream);
                    switch (this.chunkHeader.getDataType()) {
                        case INT32: {
                            this.chunkWriter.write(time, ReadWriteIOUtils.readInt((InputStream)stream));
                            continue block9;
                        }
                        case INT64: {
                            this.chunkWriter.write(time, ReadWriteIOUtils.readLong((InputStream)stream));
                            continue block9;
                        }
                        case FLOAT: {
                            this.chunkWriter.write(time, ReadWriteIOUtils.readFloat((InputStream)stream));
                            continue block9;
                        }
                        case DOUBLE: {
                            this.chunkWriter.write(time, ReadWriteIOUtils.readDouble((InputStream)stream));
                            continue block9;
                        }
                        case BOOLEAN: {
                            this.chunkWriter.write(time, ReadWriteIOUtils.readBool((InputStream)stream));
                            continue block9;
                        }
                        case TEXT: {
                            this.chunkWriter.write(time, ReadWriteIOUtils.readBinary((InputStream)stream));
                            continue block9;
                        }
                        default: {
                            throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", this.chunkHeader.getDataType()));
                        }
                    }
                }
                this.chunkWriter.sealCurrentPage();
                continue;
            }
            PageHeader pageHeader = PageHeader.deserializeFrom((InputStream)stream, (TSDataType)this.chunkHeader.getDataType(), (boolean)true);
            this.chunkWriter.writePageHeaderAndDataIntoBuff(ByteBuffer.wrap(ReadWriteIOUtils.readBytesWithSelfDescriptionLength((InputStream)stream)), pageHeader);
        }
    }

    private void deserializeEntireChunk(InputStream stream) throws IOException {
        ByteBuffer chunkData = ByteBuffer.wrap(ReadWriteIOUtils.readBytesWithSelfDescriptionLength((InputStream)stream));
        Statistics statistics = Statistics.deserialize((InputStream)stream, (TSDataType)this.chunkHeader.getDataType());
        this.chunk = new Chunk(this.chunkHeader, chunkData, null, statistics);
    }

    public static NonAlignedChunkData deserialize(InputStream stream) throws IOException, PageException {
        long timePartition = ReadWriteIOUtils.readLong((InputStream)stream);
        String device = ReadWriteIOUtils.readString((InputStream)stream);
        byte chunkType = ReadWriteIOUtils.readByte((InputStream)stream);
        ChunkHeader chunkHeader = ChunkHeader.deserializeFrom((InputStream)stream, (byte)chunkType);
        NonAlignedChunkData chunkData = new NonAlignedChunkData(-1L, device, chunkHeader);
        chunkData.setTimePartitionSlot(TimePartitionUtils.getTimePartitionForRouting(timePartition));
        chunkData.deserializeTsFileData(stream);
        return chunkData;
    }

    public String toString() {
        return "NonAlignedChunkData{offset=" + this.offset + ", dataSize=" + this.dataSize + ", isHeadPageNeedDecode=" + this.isHeadPageNeedDecode + ", isTailPageNeedDecode=" + this.isTailPageNeedDecode + ", timePartitionSlot=" + this.timePartitionSlot + ", device='" + this.device + '\'' + ", chunkHeader=" + this.chunkHeader + '}';
    }
}

