/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.performer.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.CompactionTaskManager;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.task.ReadPointPerformerSubTask;
import org.apache.iotdb.db.engine.compaction.inner.utils.MultiTsFileDeviceIterator;
import org.apache.iotdb.db.engine.compaction.performer.ICrossCompactionPerformer;
import org.apache.iotdb.db.engine.compaction.performer.IUnseqCompactionPerformer;
import org.apache.iotdb.db.engine.compaction.reader.IDataBlockReader;
import org.apache.iotdb.db.engine.compaction.reader.SeriesDataBlockReader;
import org.apache.iotdb.db.engine.compaction.task.CompactionTaskSummary;
import org.apache.iotdb.db.engine.compaction.writer.AbstractCompactionWriter;
import org.apache.iotdb.db.engine.compaction.writer.CrossSpaceCompactionWriter;
import org.apache.iotdb.db.engine.compaction.writer.InnerSpaceCompactionWriter;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.utils.QueryUtils;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadPointCompactionPerformer
implements ICrossCompactionPerformer,
IUnseqCompactionPerformer {
    private Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    private List<TsFileResource> seqFiles = Collections.emptyList();
    private List<TsFileResource> unseqFiles = Collections.emptyList();
    private static final int subTaskNum = IoTDBDescriptor.getInstance().getConfig().getSubCompactionTaskNum();
    private CompactionTaskSummary summary;
    private List<TsFileResource> targetFiles = Collections.emptyList();

    public ReadPointCompactionPerformer(List<TsFileResource> seqFiles, List<TsFileResource> unseqFiles, List<TsFileResource> targetFiles) {
        this.seqFiles = seqFiles;
        this.unseqFiles = unseqFiles;
        this.targetFiles = targetFiles;
    }

    public ReadPointCompactionPerformer(List<TsFileResource> seqFiles, List<TsFileResource> unseqFiles) {
        this.seqFiles = seqFiles;
        this.unseqFiles = unseqFiles;
    }

    public ReadPointCompactionPerformer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform() throws IOException, MetadataException, StorageEngineException, InterruptedException, ExecutionException {
        long queryId = QueryResourceManager.getInstance().assignCompactionQueryId();
        FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContextForCompaction(queryId);
        QueryDataSource queryDataSource = new QueryDataSource(this.seqFiles, this.unseqFiles);
        QueryResourceManager.getInstance().getQueryFileManager().addUsedFilesForQuery(queryId, queryDataSource);
        try (AbstractCompactionWriter compactionWriter = this.getCompactionWriter(this.seqFiles, this.unseqFiles, this.targetFiles);){
            MultiTsFileDeviceIterator deviceIterator = new MultiTsFileDeviceIterator(this.seqFiles, this.unseqFiles);
            while (deviceIterator.hasNextDevice()) {
                this.checkThreadInterrupted();
                Pair<String, Boolean> deviceInfo = deviceIterator.nextDevice();
                String device = (String)deviceInfo.left;
                boolean isAligned = (Boolean)deviceInfo.right;
                QueryUtils.fillOrderIndexes(queryDataSource, device, true);
                if (isAligned) {
                    this.compactAlignedSeries(device, deviceIterator, compactionWriter, fragmentInstanceContext, queryDataSource);
                    continue;
                }
                this.compactNonAlignedSeries(device, deviceIterator, compactionWriter, fragmentInstanceContext, queryDataSource);
            }
            compactionWriter.endFile();
            ReadPointCompactionPerformer.updatePlanIndexes(this.targetFiles, this.seqFiles, this.unseqFiles);
        }
        finally {
            QueryResourceManager.getInstance().endQuery(queryId);
        }
    }

    @Override
    public void setTargetFiles(List<TsFileResource> targetFiles) {
        this.targetFiles = targetFiles;
    }

    @Override
    public void setSummary(CompactionTaskSummary summary) {
        this.summary = summary;
    }

    private void compactAlignedSeries(String device, MultiTsFileDeviceIterator deviceIterator, AbstractCompactionWriter compactionWriter, FragmentInstanceContext fragmentInstanceContext, QueryDataSource queryDataSource) throws IOException, MetadataException {
        Map<String, MeasurementSchema> schemaMap = deviceIterator.getAllSchemasOfCurrentDevice();
        ArrayList<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>(schemaMap.values());
        if (measurementSchemas.isEmpty()) {
            return;
        }
        List<String> existedMeasurements = measurementSchemas.stream().map(IMeasurementSchema::getMeasurementId).collect(Collectors.toList());
        IDataBlockReader dataBlockReader = ReadPointCompactionPerformer.constructReader(device, existedMeasurements, measurementSchemas, new ArrayList<String>(schemaMap.keySet()), fragmentInstanceContext, queryDataSource, true);
        if (dataBlockReader.hasNextBatch()) {
            compactionWriter.startChunkGroup(device, true);
            compactionWriter.startMeasurement(measurementSchemas, 0);
            ReadPointCompactionPerformer.writeWithReader(compactionWriter, dataBlockReader, device, 0, true);
            compactionWriter.endMeasurement(0);
            compactionWriter.endChunkGroup();
            compactionWriter.checkAndMayFlushChunkMetadata();
        }
    }

    private void compactNonAlignedSeries(String device, MultiTsFileDeviceIterator deviceIterator, AbstractCompactionWriter compactionWriter, FragmentInstanceContext fragmentInstanceContext, QueryDataSource queryDataSource) throws IOException, InterruptedException, ExecutionException {
        Map<String, MeasurementSchema> schemaMap = deviceIterator.getAllSchemasOfCurrentDevice();
        ArrayList<String> allMeasurements = new ArrayList<String>(schemaMap.keySet());
        allMeasurements.sort(String::compareTo);
        int subTaskNums = Math.min(allMeasurements.size(), subTaskNum);
        if (subTaskNums > 0) {
            List[] measurementListArray = new List[subTaskNums];
            int size = allMeasurements.size();
            for (int i = 0; i < size; ++i) {
                int n = i % subTaskNums;
                if (measurementListArray[n] == null) {
                    measurementListArray[n] = new LinkedList();
                }
                measurementListArray[n].add((String)allMeasurements.get(i));
            }
            compactionWriter.startChunkGroup(device, false);
            ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
            for (int i = 0; i < subTaskNums; ++i) {
                futures.add(CompactionTaskManager.getInstance().submitSubTask(new ReadPointPerformerSubTask(device, measurementListArray[i], fragmentInstanceContext, queryDataSource, compactionWriter, schemaMap, i)));
            }
            for (Future future : futures) {
                future.get();
            }
            compactionWriter.checkAndMayFlushChunkMetadata();
            compactionWriter.endChunkGroup();
        }
    }

    private static void updateDeviceStartTimeAndEndTime(List<TsFileResource> targetResources, AbstractCompactionWriter compactionWriter) {
        List<TsFileIOWriter> targetFileWriters = compactionWriter.getFileIOWriter();
        for (int i = 0; i < targetFileWriters.size(); ++i) {
            TsFileIOWriter fileIOWriter = targetFileWriters.get(i);
            TsFileResource fileResource = targetResources.get(i);
            if (!fileResource.getTsFile().exists()) continue;
            for (Map.Entry entry : fileIOWriter.getDeviceTimeseriesMetadataMap().entrySet()) {
                String device = (String)entry.getKey();
                for (TimeseriesMetadata timeseriesMetadata : (List)entry.getValue()) {
                    fileResource.updateStartTime(device, timeseriesMetadata.getStatistics().getStartTime());
                    fileResource.updateEndTime(device, timeseriesMetadata.getStatistics().getEndTime());
                }
            }
        }
    }

    public static IDataBlockReader constructReader(String deviceId, List<String> measurementIds, List<IMeasurementSchema> measurementSchemas, List<String> allSensors, FragmentInstanceContext fragmentInstanceContext, QueryDataSource queryDataSource, boolean isAlign) throws IllegalPathException {
        TSDataType tsDataType;
        AlignedPath seriesPath;
        if (isAlign) {
            seriesPath = new AlignedPath(deviceId, measurementIds, measurementSchemas);
            tsDataType = TSDataType.VECTOR;
        } else {
            seriesPath = new MeasurementPath(deviceId, measurementIds.get(0), measurementSchemas.get(0));
            tsDataType = measurementSchemas.get(0).getType();
        }
        return new SeriesDataBlockReader((PartialPath)seriesPath, new HashSet<String>(allSensors), tsDataType, fragmentInstanceContext, queryDataSource, true);
    }

    public static void writeWithReader(AbstractCompactionWriter writer, IDataBlockReader reader, String device, int subTaskId, boolean isAligned) throws IOException {
        while (reader.hasNextBatch()) {
            TsBlock tsBlock = reader.nextBatch();
            if (isAligned) {
                writer.write(tsBlock.getTimeColumn(), tsBlock.getValueColumns(), device, subTaskId, tsBlock.getPositionCount());
                continue;
            }
            TsBlock.TsBlockSingleColumnIterator pointReader = tsBlock.getTsBlockSingleColumnIterator();
            TimeValuePair timeValuePair = null;
            boolean updateFirstTime = false;
            while (pointReader.hasNextTimeValuePair()) {
                timeValuePair = pointReader.nextTimeValuePair();
                if (!updateFirstTime) {
                    writer.updateStartTimeAndEndTime(device, timeValuePair.getTimestamp(), subTaskId);
                    updateFirstTime = true;
                }
                writer.write(timeValuePair.getTimestamp(), timeValuePair.getValue().getValue(), subTaskId);
            }
            if (timeValuePair == null) continue;
            writer.updateStartTimeAndEndTime(device, timeValuePair.getTimestamp(), subTaskId);
        }
    }

    private AbstractCompactionWriter getCompactionWriter(List<TsFileResource> seqFileResources, List<TsFileResource> unseqFileResources, List<TsFileResource> targetFileResources) throws IOException {
        if (!seqFileResources.isEmpty() && !unseqFileResources.isEmpty()) {
            return new CrossSpaceCompactionWriter(targetFileResources, seqFileResources);
        }
        return new InnerSpaceCompactionWriter(targetFileResources.get(0));
    }

    private static void updatePlanIndexes(List<TsFileResource> targetResources, List<TsFileResource> seqResources, List<TsFileResource> unseqResources) {
        for (int i = 0; i < targetResources.size(); ++i) {
            TsFileResource targetResource = targetResources.get(i);
            if (!targetResource.getTsFile().exists()) {
                targetResources.remove(i--);
                continue;
            }
            for (TsFileResource unseqResource : unseqResources) {
                targetResource.updatePlanIndexes(unseqResource);
            }
            for (TsFileResource seqResource : seqResources) {
                targetResource.updatePlanIndexes(seqResource);
            }
        }
    }

    private void checkThreadInterrupted() throws InterruptedException {
        if (Thread.interrupted() || this.summary.isCancel()) {
            throw new InterruptedException(String.format("[Compaction] compaction for target file %s abort", this.targetFiles.toString()));
        }
    }

    @Override
    public void setSourceFiles(List<TsFileResource> seqFiles, List<TsFileResource> unseqFiles) {
        this.seqFiles = seqFiles;
        this.unseqFiles = unseqFiles;
    }

    @Override
    public void setSourceFiles(List<TsFileResource> unseqFiles) {
        this.unseqFiles = unseqFiles;
    }
}

