/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.cache.ChunkCacheMetrics;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.db.service.metrics.MetricService;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.utils.RamUsageEstimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkCache {
    private static final Logger logger = LoggerFactory.getLogger(ChunkCache.class);
    private static final Logger DEBUG_LOGGER = LoggerFactory.getLogger((String)"QUERY_DEBUG");
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final long MEMORY_THRESHOLD_IN_CHUNK_CACHE = config.getAllocateMemoryForChunkCache();
    private static final boolean CACHE_ENABLE = config.isMetaDataCacheEnable();
    private final LoadingCache<ChunkMetadata, Chunk> lruCache;
    private final AtomicLong entryAverageSize = new AtomicLong(0L);

    private ChunkCache() {
        if (CACHE_ENABLE) {
            logger.info("ChunkCache size = " + MEMORY_THRESHOLD_IN_CHUNK_CACHE);
        }
        this.lruCache = Caffeine.newBuilder().maximumWeight(MEMORY_THRESHOLD_IN_CHUNK_CACHE).weigher((chunkMetadata, chunk) -> (int)((long)RamUsageEstimator.NUM_BYTES_OBJECT_REF + RamUsageEstimator.sizeOf((Object)chunk))).recordStats().build(chunkMetadata -> {
            try {
                TsFileSequenceReader reader = FileReaderManager.getInstance().get(chunkMetadata.getFilePath(), chunkMetadata.isClosed());
                return reader.readMemChunk(chunkMetadata);
            }
            catch (IOException e) {
                logger.error("Something wrong happened in reading {}", chunkMetadata, (Object)e);
                throw e;
            }
        });
        MetricService.getInstance().addMetricSet(new ChunkCacheMetrics(this));
    }

    public double getHitRate() {
        return this.lruCache.stats().hitRate() * 100.0;
    }

    public static ChunkCache getInstance() {
        return ChunkCacheHolder.INSTANCE;
    }

    public Chunk get(ChunkMetadata chunkMetaData) throws IOException {
        return this.get(chunkMetaData, false);
    }

    public Chunk get(ChunkMetadata chunkMetaData, boolean debug) throws IOException {
        if (!CACHE_ENABLE) {
            TsFileSequenceReader reader = FileReaderManager.getInstance().get(chunkMetaData.getFilePath(), chunkMetaData.isClosed());
            Chunk chunk = reader.readMemChunk(chunkMetaData);
            return new Chunk(chunk.getHeader(), chunk.getData().duplicate(), chunkMetaData.getDeleteIntervalList(), chunkMetaData.getStatistics());
        }
        Chunk chunk = (Chunk)this.lruCache.get((Object)chunkMetaData);
        if (debug) {
            DEBUG_LOGGER.info("get chunk from cache whose meta data is: " + chunkMetaData);
        }
        return new Chunk(chunk.getHeader(), chunk.getData().duplicate(), chunkMetaData.getDeleteIntervalList(), chunkMetaData.getStatistics());
    }

    public double calculateChunkHitRatio() {
        return this.lruCache.stats().hitRate();
    }

    public long getEvictionCount() {
        return this.lruCache.stats().evictionCount();
    }

    public long getMaxMemory() {
        return MEMORY_THRESHOLD_IN_CHUNK_CACHE;
    }

    public double getAverageLoadPenalty() {
        return this.lruCache.stats().averageLoadPenalty();
    }

    public long getAverageSize() {
        return this.entryAverageSize.get();
    }

    public void clear() {
        this.lruCache.invalidateAll();
        this.lruCache.cleanUp();
    }

    public void remove(ChunkMetadata chunkMetaData) {
        this.lruCache.invalidate((Object)chunkMetaData);
    }

    public boolean isEmpty() {
        return this.lruCache.asMap().isEmpty();
    }

    private static class ChunkCacheHolder {
        private static final ChunkCache INSTANCE = new ChunkCache();

        private ChunkCacheHolder() {
        }
    }
}

