/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.iotdb.cli.utils.JlineUtils;
import org.apache.iotdb.exception.ArgsErrorException;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.session.SessionDataSet;
import org.apache.iotdb.tool.AbstractTsFileTool;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.jline.reader.LineReader;

public class ExportTsFile
extends AbstractTsFileTool {
    private static final String TARGET_DIR_ARGS = "td";
    private static final String TARGET_DIR_NAME = "targetDirectory";
    private static final String TARGET_FILE_ARGS = "f";
    private static final String TARGET_FILE_NAME = "targetFile";
    private static final String SQL_FILE_ARGS = "s";
    private static final String SQL_FILE_NAME = "sqlfile";
    private static final String QUERY_COMMAND_ARGS = "q";
    private static final String QUERY_COMMAND_NAME = "queryCommand";
    private static final String DUMP_FILE_NAME_DEFAULT = "dump";
    private static final String TSFILEDB_CLI_PREFIX = "ExportTsFile";
    private static String targetDirectory;
    private static String targetFile;
    private static String queryCommand;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Options options = ExportTsFile.createOptions();
        HelpFormatter hf = new HelpFormatter();
        CommandLine commandLine = null;
        DefaultParser parser = new DefaultParser();
        hf.setOptionComparator(null);
        hf.setWidth(92);
        if (args == null || args.length == 0) {
            System.out.println("Too few params input, please check the following hint.");
            hf.printHelp(TSFILEDB_CLI_PREFIX, options, true);
            System.exit(1);
        }
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            hf.printHelp(TSFILEDB_CLI_PREFIX, options, true);
            System.exit(1);
        }
        if (commandLine.hasOption("help")) {
            hf.printHelp(TSFILEDB_CLI_PREFIX, options, true);
            System.exit(1);
        }
        int exitCode = 0;
        try {
            ExportTsFile.parseBasicParams(commandLine);
            ExportTsFile.parseSpecialParams(commandLine);
            session = new Session(host, Integer.parseInt(port), username, password);
            session.open(false);
            if (queryCommand == null) {
                String sqlFile = commandLine.getOptionValue(SQL_FILE_ARGS);
                if (sqlFile == null) {
                    LineReader lineReader = JlineUtils.getLineReader(username, host, port);
                    String sql = lineReader.readLine("ExportTsFile> please input query: ");
                    System.out.println(sql);
                    String[] values = sql.trim().split(";");
                    for (int i = 0; i < values.length; ++i) {
                        ExportTsFile.legalCheck(values[i]);
                        ExportTsFile.dumpResult(values[i], i);
                    }
                } else {
                    ExportTsFile.dumpFromSqlFile(sqlFile);
                }
            } else {
                ExportTsFile.legalCheck(queryCommand);
                ExportTsFile.dumpResult(queryCommand, 0);
            }
        }
        catch (IOException e) {
            System.out.println("Failed to operate on file, because " + e.getMessage());
            exitCode = 1;
        }
        catch (ArgsErrorException e) {
            System.out.println("Invalid args: " + e.getMessage());
            exitCode = 1;
        }
        catch (IoTDBConnectionException e) {
            System.out.println("Connect failed because " + e.getMessage());
            exitCode = 1;
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (IoTDBConnectionException e) {
                    exitCode = 1;
                    System.out.println("Encounter an error when closing session, error is: " + e.getMessage());
                }
            }
        }
        System.exit(exitCode);
    }

    private static void legalCheck(String sql) {
        String sqlLower = sql.toLowerCase();
        if (sqlLower.contains("count(") || sqlLower.contains("sum(") || sqlLower.contains("avg(") || sqlLower.contains("extreme(") || sqlLower.contains("max_value(") || sqlLower.contains("min_value(") || sqlLower.contains("first_value(") || sqlLower.contains("last_value(") || sqlLower.contains("max_time(") || sqlLower.contains("min_time(")) {
            System.out.println("The sql you entered is invalid, please don't use aggregate query.");
            System.exit(1);
        }
    }

    private static void parseSpecialParams(CommandLine commandLine) throws ArgsErrorException {
        targetDirectory = ExportTsFile.checkRequiredArg(TARGET_DIR_ARGS, TARGET_DIR_NAME, commandLine);
        queryCommand = commandLine.getOptionValue(QUERY_COMMAND_ARGS);
        targetFile = commandLine.getOptionValue(TARGET_FILE_ARGS);
        if (targetFile == null) {
            targetFile = DUMP_FILE_NAME_DEFAULT;
        }
        if (!targetDirectory.endsWith("/") && !targetDirectory.endsWith("\\")) {
            targetDirectory = targetDirectory + File.separator;
        }
    }

    private static Options createOptions() {
        Options options = ExportTsFile.createNewOptions();
        Option opTargetFile = Option.builder((String)TARGET_DIR_ARGS).required().argName(TARGET_DIR_NAME).hasArg().desc("Target File Directory (required)").build();
        options.addOption(opTargetFile);
        Option targetFileName = Option.builder((String)TARGET_FILE_ARGS).argName(TARGET_FILE_NAME).hasArg().desc("Export file name (optional)").build();
        options.addOption(targetFileName);
        Option opSqlFile = Option.builder((String)SQL_FILE_ARGS).argName(SQL_FILE_NAME).hasArg().desc("SQL File Path (optional)").build();
        options.addOption(opSqlFile);
        Option opQuery = Option.builder((String)QUERY_COMMAND_ARGS).argName(QUERY_COMMAND_NAME).hasArg().desc("The query command that you want to execute. (optional)").build();
        options.addOption(opQuery);
        Option opHelp = Option.builder((String)"help").longOpt("help").hasArg(false).desc("Display help information").build();
        options.addOption(opHelp);
        return options;
    }

    private static void dumpFromSqlFile(String filePath) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String sql;
            int i = 0;
            while ((sql = reader.readLine()) != null) {
                ExportTsFile.legalCheck(sql);
                ExportTsFile.dumpResult(sql, i++);
            }
        }
    }

    private static void dumpResult(String sql, int index) {
        String path = targetDirectory + targetFile + index + ".tsfile";
        try {
            SessionDataSet sessionDataSet = session.executeQueryStatement(sql, 10000L);
            long start = System.currentTimeMillis();
            ExportTsFile.writeTsFileFile(sessionDataSet, path);
            long end = System.currentTimeMillis();
            sessionDataSet.closeOperationHandle();
            System.out.println("Export completely!cost:" + (end - start) + "ms.");
        }
        catch (IOException | IoTDBConnectionException | StatementExecutionException | WriteProcessException e) {
            System.out.println("Cannot dump result because: " + e.getMessage());
        }
    }

    public static void writeTsFileFile(SessionDataSet sessionDataSet, String filePath) throws IOException, IoTDBConnectionException, StatementExecutionException, WriteProcessException {
        List columnNames = sessionDataSet.getColumnNames();
        List columnTypes = sessionDataSet.getColumnTypes();
        File f = FSFactoryProducer.getFSFactory().getFile(filePath);
        if (f.exists()) {
            f.delete();
        }
        HashSet<String> deviceFilterSet = new HashSet<String>();
        try (TsFileWriter tsFileWriter = new TsFileWriter(f);){
            LinkedHashMap<String, List> schemaMap = new LinkedHashMap<String, List>();
            for (int i = 0; i < columnNames.size(); ++i) {
                String column = (String)columnNames.get(i);
                if (!column.startsWith("root.")) continue;
                TSDataType tsDataType = ExportTsFile.getTsDataType((String)columnTypes.get(i));
                Path path = new Path(column, true);
                String deviceId = path.getDevice();
                List deviceList = session.executeQueryStatement("show devices " + deviceId, 10000L).next().getFields();
                if (deviceList.size() > 1 && "true".equals(((Field)deviceList.get(1)).getStringValue())) {
                    deviceFilterSet.add(deviceId);
                }
                MeasurementSchema measurementSchema = new MeasurementSchema(path.getMeasurement(), tsDataType);
                schemaMap.computeIfAbsent(deviceId, key -> new ArrayList()).add(measurementSchema);
            }
            ArrayList<Tablet> tabletList = new ArrayList<Tablet>();
            for (String deviceId : schemaMap.keySet()) {
                List schemaList = (List)schemaMap.get(deviceId);
                Tablet tablet = new Tablet(deviceId, schemaList);
                tablet.initBitMaps();
                Path path = new Path(tablet.deviceId);
                if (deviceFilterSet.contains(tablet.deviceId)) {
                    tsFileWriter.registerAlignedTimeseries(path, schemaList);
                } else {
                    tsFileWriter.registerTimeseries(path, schemaList);
                }
                tabletList.add(tablet);
            }
            if (tabletList.isEmpty()) {
                System.out.println("!!!Warning:Tablet is empty,no data can be exported.");
                System.exit(1);
            }
            while (sessionDataSet.hasNext()) {
                RowRecord rowRecord = sessionDataSet.next();
                List fields = rowRecord.getFields();
                int i = 0;
                while (i < fields.size()) {
                    for (Tablet tablet : tabletList) {
                        int rowIndex;
                        ++tablet.rowSize;
                        tablet.addTimestamp(rowIndex, rowRecord.getTimestamp());
                        List schemas = tablet.getSchemas();
                        for (int j = 0; j < schemas.size(); ++j) {
                            MeasurementSchema measurementSchema = (MeasurementSchema)schemas.get(j);
                            Object value = ((Field)fields.get(i)).getObjectValue(measurementSchema.getType());
                            if (value == null) {
                                tablet.bitMaps[j].mark(rowIndex);
                            }
                            tablet.addValue(measurementSchema.getMeasurementId(), rowIndex, value);
                            ++i;
                        }
                        if (tablet.rowSize != tablet.getMaxRowNumber()) continue;
                        ExportTsFile.writeToTsfile(deviceFilterSet, tsFileWriter, tablet);
                        tablet.initBitMaps();
                        tablet.reset();
                    }
                }
            }
            for (Tablet tablet : tabletList) {
                if (tablet.rowSize == 0) continue;
                ExportTsFile.writeToTsfile(deviceFilterSet, tsFileWriter, tablet);
            }
            tsFileWriter.flushAllChunkGroups();
        }
    }

    private static void writeToTsfile(HashSet<String> deviceFilterSet, TsFileWriter tsFileWriter, Tablet tablet) throws IOException, WriteProcessException {
        if (deviceFilterSet.contains(tablet.deviceId)) {
            tsFileWriter.writeAligned(tablet);
        } else {
            tsFileWriter.write(tablet);
        }
    }

    private static TSDataType getTsDataType(String type) {
        switch (type) {
            case "INT64": {
                return TSDataType.INT64;
            }
            case "INT32": {
                return TSDataType.INT32;
            }
            case "FLOAT": {
                return TSDataType.FLOAT;
            }
            case "DOUBLE": {
                return TSDataType.DOUBLE;
            }
            case "TEXT": {
                return TSDataType.TEXT;
            }
            case "BOOLEAN": {
                return TSDataType.BOOLEAN;
            }
        }
        throw new IllegalArgumentException("Invalid input: " + type);
    }

    static {
        targetFile = DUMP_FILE_NAME_DEFAULT;
    }
}

