/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool;

import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.iotdb.exception.ArgsErrorException;
import org.apache.iotdb.session.Session;

public abstract class AbstractTsFileTool {
    protected static final String HOST_ARGS = "h";
    protected static final String HOST_NAME = "host";
    protected static final String HELP_ARGS = "help";
    protected static final String PORT_ARGS = "p";
    protected static final String PORT_NAME = "port";
    protected static final String PASSWORD_ARGS = "pw";
    protected static final String PASSWORD_NAME = "password";
    protected static final String USERNAME_ARGS = "u";
    protected static final String USERNAME_NAME = "username";
    protected static final int MAX_HELP_CONSOLE_WIDTH = 92;
    protected static final int CODE_OK = 0;
    protected static final int CODE_ERROR = 1;
    protected static String host;
    protected static String port;
    protected static String username;
    protected static String password;
    protected static Session session;

    protected static String checkRequiredArg(String arg, String name, CommandLine commandLine) throws ArgsErrorException {
        String str = commandLine.getOptionValue(arg);
        if (str == null) {
            String msg = String.format("Required values for option '%s' not provided", name);
            System.out.println(msg);
            System.out.println("Use -help for more information");
            throw new ArgsErrorException(msg);
        }
        return str;
    }

    protected static void parseBasicParams(CommandLine commandLine) throws ArgsErrorException, IOException {
        host = AbstractTsFileTool.checkRequiredArg(HOST_ARGS, HOST_NAME, commandLine);
        port = AbstractTsFileTool.checkRequiredArg(PORT_ARGS, PORT_NAME, commandLine);
        username = AbstractTsFileTool.checkRequiredArg(USERNAME_ARGS, USERNAME_NAME, commandLine);
        password = commandLine.getOptionValue(PASSWORD_ARGS);
    }

    protected static Options createNewOptions() {
        Options options = new Options();
        Option opHost = Option.builder((String)HOST_ARGS).longOpt(HOST_NAME).required().argName(HOST_NAME).hasArg().desc("Host Name (required)").build();
        options.addOption(opHost);
        Option opPort = Option.builder((String)PORT_ARGS).longOpt(PORT_NAME).required().argName(PORT_NAME).hasArg().desc("Port (required)").build();
        options.addOption(opPort);
        Option opUsername = Option.builder((String)USERNAME_ARGS).longOpt(USERNAME_NAME).required().argName(USERNAME_NAME).hasArg().desc("Username (required)").build();
        options.addOption(opUsername);
        Option opPassword = Option.builder((String)PASSWORD_ARGS).longOpt(PASSWORD_NAME).optionalArg(true).argName(PASSWORD_NAME).hasArg().desc("Password (required)").build();
        options.addOption(opPassword);
        return options;
    }
}

