/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.utils;

import java.io.DataOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSchemaNode;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.exception.runtime.ThriftSerDeException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TByteBuffer;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class ThriftCommonsSerDeUtils {
    private ThriftCommonsSerDeUtils() {
    }

    private static TBinaryProtocol generateWriteProtocol(DataOutputStream stream) throws TTransportException {
        TIOStreamTransport transport = new TIOStreamTransport((OutputStream)stream);
        return new TBinaryProtocol((TTransport)transport);
    }

    private static TBinaryProtocol generateWriteProtocol(ByteBuffer buffer) throws TTransportException {
        TByteBuffer transport = new TByteBuffer(buffer);
        return new TBinaryProtocol((TTransport)transport);
    }

    private static TBinaryProtocol generateReadProtocol(ByteBuffer buffer) throws TTransportException {
        TByteBuffer transport = new TByteBuffer(buffer);
        return new TBinaryProtocol((TTransport)transport);
    }

    public static void serializeTEndPoint(TEndPoint endPoint, DataOutputStream stream) {
        try {
            endPoint.write((TProtocol)ThriftCommonsSerDeUtils.generateWriteProtocol(stream));
        }
        catch (TException e) {
            throw new ThriftSerDeException("Write TEndPoint failed: ", e);
        }
    }

    public static TEndPoint deserializeTEndPoint(ByteBuffer buffer) {
        TEndPoint endPoint = new TEndPoint();
        try {
            endPoint.read((TProtocol)ThriftCommonsSerDeUtils.generateReadProtocol(buffer));
        }
        catch (TException e) {
            throw new ThriftSerDeException("Read TEndPoint failed: ", e);
        }
        return endPoint;
    }

    public static void serializeTDataNodeLocation(TDataNodeLocation dataNodeLocation, DataOutputStream stream) {
        try {
            dataNodeLocation.write((TProtocol)ThriftCommonsSerDeUtils.generateWriteProtocol(stream));
        }
        catch (TException e) {
            throw new ThriftSerDeException("Write TDataNodeLocation failed: ", e);
        }
    }

    public static TDataNodeLocation deserializeTDataNodeLocation(ByteBuffer buffer) {
        TDataNodeLocation dataNodeLocation = new TDataNodeLocation();
        try {
            dataNodeLocation.read((TProtocol)ThriftCommonsSerDeUtils.generateReadProtocol(buffer));
        }
        catch (TException e) {
            throw new ThriftSerDeException("Read TDataNodeLocation failed: ", e);
        }
        return dataNodeLocation;
    }

    public static void serializeTDataNodeInfo(TDataNodeConfiguration dataNodeInfo, DataOutputStream stream) {
        try {
            dataNodeInfo.write((TProtocol)ThriftCommonsSerDeUtils.generateWriteProtocol(stream));
        }
        catch (TException e) {
            throw new ThriftSerDeException("Write TDataNodeInfo failed: ", e);
        }
    }

    public static TDataNodeConfiguration deserializeTDataNodeInfo(ByteBuffer buffer) {
        TDataNodeConfiguration dataNodeInfo = new TDataNodeConfiguration();
        try {
            dataNodeInfo.read((TProtocol)ThriftCommonsSerDeUtils.generateReadProtocol(buffer));
        }
        catch (TException e) {
            throw new ThriftSerDeException("Read TDataNodeInfo failed: ", e);
        }
        return dataNodeInfo;
    }

    public static void serializeTSeriesPartitionSlot(TSeriesPartitionSlot seriesPartitionSlot, DataOutputStream stream) {
        try {
            seriesPartitionSlot.write((TProtocol)ThriftCommonsSerDeUtils.generateWriteProtocol(stream));
        }
        catch (TException e) {
            throw new ThriftSerDeException("Write TSeriesPartitionSlot failed: ", e);
        }
    }

    public static TSeriesPartitionSlot deserializeTSeriesPartitionSlot(ByteBuffer buffer) {
        TSeriesPartitionSlot seriesPartitionSlot = new TSeriesPartitionSlot();
        try {
            seriesPartitionSlot.read((TProtocol)ThriftCommonsSerDeUtils.generateReadProtocol(buffer));
        }
        catch (TException e) {
            throw new ThriftSerDeException("Read TSeriesPartitionSlot failed: ", e);
        }
        return seriesPartitionSlot;
    }

    public static void serializeTTimePartitionSlot(TTimePartitionSlot timePartitionSlot, DataOutputStream stream) {
        try {
            timePartitionSlot.write((TProtocol)ThriftCommonsSerDeUtils.generateWriteProtocol(stream));
        }
        catch (TException e) {
            throw new ThriftSerDeException("Write TTimePartitionSlot failed: ", e);
        }
    }

    public static TTimePartitionSlot deserializeTTimePartitionSlot(ByteBuffer buffer) {
        TTimePartitionSlot timePartitionSlot = new TTimePartitionSlot();
        try {
            timePartitionSlot.read((TProtocol)ThriftCommonsSerDeUtils.generateReadProtocol(buffer));
        }
        catch (TException e) {
            throw new ThriftSerDeException("Read TTimePartitionSlot failed: ", e);
        }
        return timePartitionSlot;
    }

    public static void serializeTConsensusGroupId(TConsensusGroupId consensusGroupId, DataOutputStream stream) {
        try {
            consensusGroupId.write((TProtocol)ThriftCommonsSerDeUtils.generateWriteProtocol(stream));
        }
        catch (TException e) {
            throw new ThriftSerDeException("Write TConsensusGroupId failed: ", e);
        }
    }

    public static TConsensusGroupId deserializeTConsensusGroupId(ByteBuffer buffer) {
        TConsensusGroupId consensusGroupId = new TConsensusGroupId();
        try {
            consensusGroupId.read((TProtocol)ThriftCommonsSerDeUtils.generateReadProtocol(buffer));
        }
        catch (TException e) {
            throw new ThriftSerDeException("Read TConsensusGroupId failed: ", e);
        }
        return consensusGroupId;
    }

    public static void serializeTRegionReplicaSet(TRegionReplicaSet regionReplicaSet, DataOutputStream stream) {
        try {
            regionReplicaSet.write((TProtocol)ThriftCommonsSerDeUtils.generateWriteProtocol(stream));
        }
        catch (TException e) {
            throw new ThriftSerDeException("Write TRegionReplicaSet failed: ", e);
        }
    }

    public static TRegionReplicaSet deserializeTRegionReplicaSet(ByteBuffer buffer) {
        TRegionReplicaSet regionReplicaSet = new TRegionReplicaSet();
        try {
            regionReplicaSet.read((TProtocol)ThriftCommonsSerDeUtils.generateReadProtocol(buffer));
        }
        catch (TException e) {
            throw new ThriftSerDeException("Read TRegionReplicaSet failed: ", e);
        }
        return regionReplicaSet;
    }

    public static void serializeTSchemaNode(TSchemaNode schemaNode, DataOutputStream stream) {
        try {
            schemaNode.write((TProtocol)ThriftCommonsSerDeUtils.generateWriteProtocol(stream));
        }
        catch (TException e) {
            throw new ThriftSerDeException("Write TSchemaNode failed: ", e);
        }
    }

    public static void serializeTSchemaNode(TSchemaNode schemaNode, ByteBuffer buffer) {
        try {
            schemaNode.write((TProtocol)ThriftCommonsSerDeUtils.generateWriteProtocol(buffer));
        }
        catch (TException e) {
            throw new ThriftSerDeException("Write TSchemaNode failed: ", e);
        }
    }

    public static TSchemaNode deserializeTSchemaNode(ByteBuffer buffer) {
        TSchemaNode schemaNode = new TSchemaNode();
        try {
            schemaNode.read((TProtocol)ThriftCommonsSerDeUtils.generateReadProtocol(buffer));
        }
        catch (TException e) {
            throw new ThriftSerDeException("Read TSchemaNode failed: ", e);
        }
        return schemaNode;
    }
}

