/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin;

import java.util.regex.Pattern;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFMatches
implements UDTF {
    private Pattern pattern;

    public void validate(UDFParameterValidator validator) throws UDFException {
        validator.validateInputSeriesNumber(1).validateRequiredAttribute("regex").validateInputSeriesDataType(0, Type.TEXT);
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) {
        this.pattern = Pattern.compile(parameters.getString("regex"));
        configurations.setAccessStrategy((AccessStrategy)new RowByRowAccessStrategy()).setOutputDataType(Type.BOOLEAN);
    }

    public void transform(Row row, PointCollector collector) throws Exception {
        collector.putBoolean(row.getTime(), this.pattern.matcher(row.getString(0)).matches());
    }
}

