/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public enum BuiltinAggregationFunction {
    MIN_TIME("min_time"),
    MAX_TIME("max_time"),
    MAX_VALUE("max_value"),
    MIN_VALUE("min_value"),
    EXTREME("extreme"),
    FIRST_VALUE("first_value"),
    LAST_VALUE("last_value"),
    COUNT("count"),
    AVG("avg"),
    SUM("sum");

    private final String functionName;
    private static final Set<String> NATIVE_FUNCTION_NAMES;

    private BuiltinAggregationFunction(String functionName) {
        this.functionName = functionName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public static Set<String> getNativeFunctionNames() {
        return NATIVE_FUNCTION_NAMES;
    }

    static {
        NATIVE_FUNCTION_NAMES = new HashSet<String>(Arrays.stream(BuiltinAggregationFunction.values()).map(BuiltinAggregationFunction::getFunctionName).collect(Collectors.toList()));
    }
}

