/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.path;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternNode;

@NotThreadSafe
public class PatternTreeMap<V, VSerializer extends PathPatternNode.Serializer<V>> {
    private final PathPatternNode<V, VSerializer> root;
    private final Supplier<? extends Set<V>> supplier;
    private final BiConsumer<V, Set<V>> appendFunction;
    private final BiConsumer<V, Set<V>> deleteFunction;
    private final VSerializer serializer;

    public PatternTreeMap(Supplier<? extends Set<V>> supplier, BiConsumer<V, Set<V>> appendFunction, BiConsumer<V, Set<V>> deleteFunction, VSerializer serializer) {
        this.root = new PathPatternNode("root", supplier, serializer);
        this.supplier = supplier;
        this.appendFunction = appendFunction;
        this.deleteFunction = deleteFunction;
        this.serializer = serializer;
    }

    public void append(PartialPath key, V value) {
        if (this.appendFunction == null) {
            throw new UnsupportedOperationException();
        }
        String[] pathNodes = key.getNodes();
        PathPatternNode<V, VSerializer> curNode = this.root;
        for (int i = 1; i < pathNodes.length; ++i) {
            PathPatternNode<V, VSerializer> nextNode = curNode.getChildren(pathNodes[i]);
            if (nextNode == null) {
                nextNode = new PathPatternNode(pathNodes[i], this.supplier, this.serializer);
                curNode.addChild(nextNode);
            }
            curNode = nextNode;
        }
        curNode.appendValue(value, this.appendFunction);
    }

    public void delete(PartialPath key, V value) {
        if (this.deleteFunction == null) {
            throw new UnsupportedOperationException();
        }
        this.deletePathNode(this.root, key.getNodes(), 0, value);
    }

    private boolean deletePathNode(PathPatternNode<V, VSerializer> node, String[] pathNodes, int pos, V value) {
        if (node == null) {
            return false;
        }
        if (pos == pathNodes.length - 1) {
            node.deleteValue(value, this.deleteFunction);
        } else {
            PathPatternNode<V, VSerializer> child = node.getChildren(pathNodes[pos + 1]);
            if (this.deletePathNode(child, pathNodes, pos + 1, value)) {
                node.deleteChild(child);
            }
        }
        return node.isLeaf() && node.getValues().isEmpty();
    }

    public List<V> getOverlapped(PartialPath fullPath) {
        ArrayList res = new ArrayList();
        this.searchOverlapped(this.root, fullPath.getNodes(), 0, res);
        return res;
    }

    private void searchOverlapped(PathPatternNode<V, VSerializer> node, String[] pathNodes, int pos, List<V> resultList) {
        if (pos == pathNodes.length - 1) {
            resultList.addAll(node.getValues());
            return;
        }
        if (node.isMultiLevelWildcard()) {
            this.searchOverlapped(node, pathNodes, pos + 1, resultList);
        }
        for (PathPatternNode<V, VSerializer> child : node.getMatchChildren(pathNodes[pos + 1])) {
            this.searchOverlapped(child, pathNodes, pos + 1, resultList);
        }
    }

    public List<List<V>> getOverlapped(PartialPath devicePath, List<String> measurements) {
        ArrayList<List<V>> res = new ArrayList<List<V>>();
        for (int i = 0; i < measurements.size(); ++i) {
            res.add(new ArrayList());
        }
        this.searchOverlapped(this.root, devicePath.getNodes(), 0, measurements, res);
        return res;
    }

    private void searchOverlapped(PathPatternNode<V, VSerializer> node, String[] deviceNodes, int pos, List<String> measurements, List<List<V>> resultList) {
        if (pos == deviceNodes.length - 1) {
            for (int i = 0; i < measurements.size(); ++i) {
                for (PathPatternNode<V, VSerializer> child : node.getMatchChildren(measurements.get(i))) {
                    resultList.get(i).addAll(child.getValues());
                }
            }
            return;
        }
        if (node.isMultiLevelWildcard()) {
            this.searchOverlapped(node, deviceNodes, pos + 1, measurements, resultList);
        }
        for (PathPatternNode<V, VSerializer> child : node.getMatchChildren(deviceNodes[pos + 1])) {
            this.searchOverlapped(child, deviceNodes, pos + 1, measurements, resultList);
        }
    }
}

