/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.consensus;

import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.consensus.PartitionRegionId;
import org.apache.iotdb.commons.consensus.SchemaRegionId;

public abstract class ConsensusGroupId {
    protected int id;

    public int getId() {
        return this.id;
    }

    public abstract TConsensusGroupType getType();

    public TConsensusGroupId convertToTConsensusGroupId() {
        return new TConsensusGroupId(this.getType(), this.getId());
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsensusGroupId that = (ConsensusGroupId)o;
        return this.getId() == that.getId() && this.getType() == that.getType();
    }

    public String toString() {
        return String.format("%s[%d]", this.getType(), this.getId());
    }

    public static String formatTConsensusGroupId(TConsensusGroupId groupId) {
        StringBuilder format = new StringBuilder();
        switch (groupId.getType()) {
            case SchemaRegion: {
                format.append("SchemaRegion");
                break;
            }
            case DataRegion: {
                format.append("DataRegion");
                break;
            }
            case PartitionRegion: {
                format.append("PartitionRegion");
            }
        }
        format.append("(").append(groupId.getId()).append(")");
        return format.toString();
    }

    public static class Factory {
        public static ConsensusGroupId create(int type, int id) {
            ConsensusGroupId groupId;
            if (type == TConsensusGroupType.DataRegion.getValue()) {
                groupId = new DataRegionId(id);
            } else if (type == TConsensusGroupType.SchemaRegion.getValue()) {
                groupId = new SchemaRegionId(id);
            } else if (type == TConsensusGroupType.PartitionRegion.getValue()) {
                groupId = new PartitionRegionId(id);
            } else {
                throw new IllegalArgumentException("Unrecognized TConsensusGroupType: " + type + " with id = " + id);
            }
            return groupId;
        }

        public static ConsensusGroupId createFromTConsensusGroupId(TConsensusGroupId tConsensusGroupId) {
            return Factory.create(tConsensusGroupId.getType().getValue(), tConsensusGroupId.getId());
        }
    }
}

