/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.client;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.client.BaseClientFactory;
import org.apache.iotdb.commons.client.ClientFactoryProperty;
import org.apache.iotdb.commons.client.ClientManager;
import org.apache.thrift.async.TAsyncClientManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsyncBaseClientFactory<K, V>
extends BaseClientFactory<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(AsyncBaseClientFactory.class);
    protected TAsyncClientManager[] tManagers;
    protected AtomicInteger clientCnt = new AtomicInteger();
    private static final String THRIFT_THREAD_NAME = "TAsyncClientManager#SelectorThread";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AsyncBaseClientFactory(ClientManager<K, V> clientManager, ClientFactoryProperty clientFactoryProperty, String threadName) {
        super(clientManager, clientFactoryProperty);
        AsyncBaseClientFactory asyncBaseClientFactory = this;
        synchronized (asyncBaseClientFactory) {
            this.tManagers = new TAsyncClientManager[clientFactoryProperty.getSelectorNumOfAsyncClientPool()];
            for (int i = 0; i < this.tManagers.length; ++i) {
                try {
                    this.tManagers[i] = new TAsyncClientManager();
                    continue;
                }
                catch (IOException e) {
                    logger.error("Cannot create Async client factory", (Throwable)e);
                }
            }
            Thread.getAllStackTraces().keySet().stream().filter(thread -> thread.getName().contains(THRIFT_THREAD_NAME)).collect(Collectors.toList()).forEach(thread -> thread.setName(threadName + "-selector-" + thread.getId()));
        }
    }
}

