/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.util;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.service.rpc.thrift.EndPoint;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionUtils {
    private static final Logger logger = LoggerFactory.getLogger(SessionUtils.class);
    private static final byte TYPE_NULL = -2;

    public static ByteBuffer getTimeBuffer(Tablet tablet) {
        ByteBuffer timeBuffer = ByteBuffer.allocate(tablet.getTimeBytesSize());
        for (int i = 0; i < tablet.rowSize; ++i) {
            timeBuffer.putLong(tablet.timestamps[i]);
        }
        timeBuffer.flip();
        return timeBuffer;
    }

    public static ByteBuffer getValueBuffer(Tablet tablet) {
        ByteBuffer valueBuffer = ByteBuffer.allocate(tablet.getTotalValueOccupation());
        for (int i = 0; i < tablet.getSchemas().size(); ++i) {
            MeasurementSchema schema = (MeasurementSchema)tablet.getSchemas().get(i);
            SessionUtils.getValueBufferOfDataType(schema.getType(), tablet, i, valueBuffer);
        }
        if (tablet.bitMaps != null) {
            for (BitMap bitMap : tablet.bitMaps) {
                boolean columnHasNull = bitMap != null && !bitMap.isAllUnmarked();
                valueBuffer.put(BytesUtils.boolToByte((boolean)columnHasNull));
                if (!columnHasNull) continue;
                byte[] bytes = bitMap.getByteArray();
                for (int j = 0; j < tablet.rowSize / 8 + 1; ++j) {
                    valueBuffer.put(bytes[j]);
                }
            }
        }
        valueBuffer.flip();
        return valueBuffer;
    }

    public static ByteBuffer getValueBuffer(List<TSDataType> types, List<Object> values) throws IoTDBConnectionException {
        ByteBuffer buffer = ByteBuffer.allocate(SessionUtils.calculateLength(types, values));
        SessionUtils.putValues(types, values, buffer);
        return buffer;
    }

    private static int calculateLength(List<TSDataType> types, List<Object> values) throws IoTDBConnectionException {
        int res = 0;
        block8: for (int i = 0; i < types.size(); ++i) {
            ++res;
            switch (types.get(i)) {
                case BOOLEAN: {
                    ++res;
                    continue block8;
                }
                case INT32: {
                    res += 4;
                    continue block8;
                }
                case INT64: {
                    res += 8;
                    continue block8;
                }
                case FLOAT: {
                    res += 4;
                    continue block8;
                }
                case DOUBLE: {
                    res += 8;
                    continue block8;
                }
                case TEXT: {
                    res += 4;
                    res += ((String)values.get(i)).getBytes(TSFileConfig.STRING_CHARSET).length;
                    continue block8;
                }
                default: {
                    throw new IoTDBConnectionException("Unsupported data type:" + types.get(i));
                }
            }
        }
        return res;
    }

    private static void putValues(List<TSDataType> types, List<Object> values, ByteBuffer buffer) throws IoTDBConnectionException {
        block8: for (int i = 0; i < values.size(); ++i) {
            if (values.get(i) == null) {
                ReadWriteIOUtils.write((byte)-2, (ByteBuffer)buffer);
                continue;
            }
            ReadWriteIOUtils.write((TSDataType)types.get(i), (ByteBuffer)buffer);
            switch (types.get(i)) {
                case BOOLEAN: {
                    ReadWriteIOUtils.write((Boolean)((Boolean)values.get(i)), (ByteBuffer)buffer);
                    continue block8;
                }
                case INT32: {
                    ReadWriteIOUtils.write((int)((Integer)values.get(i)), (ByteBuffer)buffer);
                    continue block8;
                }
                case INT64: {
                    ReadWriteIOUtils.write((long)((Long)values.get(i)), (ByteBuffer)buffer);
                    continue block8;
                }
                case FLOAT: {
                    ReadWriteIOUtils.write((float)((Float)values.get(i)).floatValue(), (ByteBuffer)buffer);
                    continue block8;
                }
                case DOUBLE: {
                    ReadWriteIOUtils.write((double)((Double)values.get(i)), (ByteBuffer)buffer);
                    continue block8;
                }
                case TEXT: {
                    byte[] bytes = ((String)values.get(i)).getBytes(TSFileConfig.STRING_CHARSET);
                    ReadWriteIOUtils.write((int)bytes.length, (ByteBuffer)buffer);
                    buffer.put(bytes);
                    continue block8;
                }
                default: {
                    throw new IoTDBConnectionException("Unsupported data type:" + types.get(i));
                }
            }
        }
        buffer.flip();
    }

    private static void getValueBufferOfDataType(TSDataType dataType, Tablet tablet, int i, ByteBuffer valueBuffer) {
        switch (dataType) {
            case INT32: {
                int[] intValues = (int[])tablet.values[i];
                for (int index = 0; index < tablet.rowSize; ++index) {
                    if (tablet.bitMaps == null || tablet.bitMaps[i] == null || !tablet.bitMaps[i].isMarked(index)) {
                        valueBuffer.putInt(intValues[index]);
                        continue;
                    }
                    valueBuffer.putInt(Integer.MIN_VALUE);
                }
                break;
            }
            case INT64: {
                long[] longValues = (long[])tablet.values[i];
                for (int index = 0; index < tablet.rowSize; ++index) {
                    if (tablet.bitMaps == null || tablet.bitMaps[i] == null || !tablet.bitMaps[i].isMarked(index)) {
                        valueBuffer.putLong(longValues[index]);
                        continue;
                    }
                    valueBuffer.putLong(Long.MIN_VALUE);
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = (float[])tablet.values[i];
                for (int index = 0; index < tablet.rowSize; ++index) {
                    if (tablet.bitMaps == null || tablet.bitMaps[i] == null || !tablet.bitMaps[i].isMarked(index)) {
                        valueBuffer.putFloat(floatValues[index]);
                        continue;
                    }
                    valueBuffer.putFloat(Float.MIN_VALUE);
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])tablet.values[i];
                for (int index = 0; index < tablet.rowSize; ++index) {
                    if (tablet.bitMaps == null || tablet.bitMaps[i] == null || !tablet.bitMaps[i].isMarked(index)) {
                        valueBuffer.putDouble(doubleValues[index]);
                        continue;
                    }
                    valueBuffer.putDouble(Double.MIN_VALUE);
                }
                break;
            }
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])tablet.values[i];
                for (int index = 0; index < tablet.rowSize; ++index) {
                    if (tablet.bitMaps == null || tablet.bitMaps[i] == null || !tablet.bitMaps[i].isMarked(index)) {
                        valueBuffer.put(BytesUtils.boolToByte((boolean)boolValues[index]));
                        continue;
                    }
                    valueBuffer.put(BytesUtils.boolToByte((boolean)false));
                }
                break;
            }
            case TEXT: {
                Binary[] binaryValues = (Binary[])tablet.values[i];
                for (int index = 0; index < tablet.rowSize; ++index) {
                    valueBuffer.putInt(binaryValues[index].getLength());
                    valueBuffer.put(binaryValues[index].getValues());
                }
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", dataType));
            }
        }
    }

    public static List<EndPoint> parseSeedNodeUrls(List<String> nodeUrls) {
        if (nodeUrls == null) {
            throw new NumberFormatException("nodeUrls is null");
        }
        ArrayList<EndPoint> endPointsList = new ArrayList<EndPoint>();
        for (String nodeUrl : nodeUrls) {
            EndPoint endPoint = SessionUtils.parseNodeUrl(nodeUrl);
            endPointsList.add(endPoint);
        }
        return endPointsList;
    }

    private static EndPoint parseNodeUrl(String nodeUrl) {
        EndPoint endPoint = new EndPoint();
        String[] split = nodeUrl.split(":");
        if (split.length != 2) {
            throw new NumberFormatException("NodeUrl Incorrect format");
        }
        String ip = split[0];
        try {
            int rpcPort = Integer.parseInt(split[1]);
            return endPoint.setIp(ip).setPort(rpcPort);
        }
        catch (Exception e) {
            throw new NumberFormatException("NodeUrl Incorrect format");
        }
    }
}

