/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.crud;

import java.util.HashSet;
import java.util.List;
import org.apache.iotdb.db.exception.query.LogicalOperatorException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.crud.AggregationQueryOperator;
import org.apache.iotdb.db.qp.logical.crud.GroupByQueryOperator;
import org.apache.iotdb.db.qp.logical.crud.LastQueryOperator;
import org.apache.iotdb.db.qp.logical.crud.QueryOperator;
import org.apache.iotdb.db.qp.logical.crud.SpecialClauseComponent;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.qp.physical.crud.SelectIntoPlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;

public class SelectIntoOperator
extends Operator {
    private QueryOperator queryOperator;
    private List<PartialPath> intoPaths;
    private boolean isIntoPathsAligned;

    public SelectIntoOperator() {
        super(109);
        this.operatorType = Operator.OperatorType.SELECT_INTO;
    }

    @Override
    public PhysicalPlan generatePhysicalPlan(PhysicalGenerator generator) throws QueryProcessException {
        QueryPlan queryPlan = (QueryPlan)this.queryOperator.generatePhysicalPlan(generator);
        if (this.intoPaths.size() != queryPlan.getPaths().size()) {
            throw new QueryProcessException("select into: the number of source paths and the number of target paths should be the same.");
        }
        return new SelectIntoPlan(queryPlan, this.queryOperator.getFromComponent().getPrefixPaths().get(0), this.intoPaths, this.isIntoPathsAligned);
    }

    public void check() throws LogicalOperatorException {
        this.queryOperator.check();
        if (this.intoPaths.size() > new HashSet<PartialPath>(this.intoPaths).size()) {
            throw new LogicalOperatorException("select into: target paths in into clause should be different.");
        }
        if (this.queryOperator.isAlignByDevice()) {
            throw new LogicalOperatorException("select into: align by device clauses are not supported.");
        }
        if (!this.queryOperator.isAlignByTime()) {
            throw new LogicalOperatorException("select into: disable align clauses are not supported.");
        }
        if (this.queryOperator instanceof LastQueryOperator) {
            throw new LogicalOperatorException("select into: last clauses are not supported.");
        }
        if (this.queryOperator instanceof AggregationQueryOperator && !(this.queryOperator instanceof GroupByQueryOperator)) {
            throw new LogicalOperatorException("select into: aggregation queries are not supported.");
        }
        if (this.queryOperator.getSpecialClauseComponent() != null) {
            SpecialClauseComponent specialClauseComponent = this.queryOperator.getSpecialClauseComponent();
            if (specialClauseComponent.hasSlimit()) {
                throw new LogicalOperatorException("select into: slimit clauses are not supported.");
            }
            if (specialClauseComponent.getSeriesOffset() > 0) {
                throw new LogicalOperatorException("select into: soffset clauses are not supported.");
            }
            if (!specialClauseComponent.isAscending()) {
                throw new LogicalOperatorException("select into: order by time desc clauses are not supported.");
            }
        }
    }

    public void setQueryOperator(QueryOperator queryOperator) {
        this.queryOperator = queryOperator;
    }

    public QueryOperator getQueryOperator() {
        return this.queryOperator;
    }

    public void setIntoPaths(List<PartialPath> intoPaths) {
        this.intoPaths = intoPaths;
    }

    public void setIntoPathsAligned(boolean isIntoPathsAligned) {
        this.isIntoPathsAligned = isIntoPathsAligned;
    }
}

