/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.engine.storagegroup.TsFileLock;
import org.apache.iotdb.db.engine.storagegroup.TsFileNameGenerator;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;
import org.apache.iotdb.db.engine.storagegroup.VirtualStorageGroupProcessor;
import org.apache.iotdb.db.engine.storagegroup.timeindex.DeviceTimeIndex;
import org.apache.iotdb.db.engine.storagegroup.timeindex.FileTimeIndex;
import org.apache.iotdb.db.engine.storagegroup.timeindex.ITimeIndex;
import org.apache.iotdb.db.engine.storagegroup.timeindex.TimeIndexLevel;
import org.apache.iotdb.db.engine.upgrade.UpgradeTask;
import org.apache.iotdb.db.exception.PartitionViolationException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.query.filter.TsFileFilter;
import org.apache.iotdb.db.service.UpgradeSevice;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.fileSystem.fsFactory.FSFactory;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.utils.FilePathUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(TsFileResource.class);
    private static final Logger DEBUG_LOGGER = LoggerFactory.getLogger((String)"QUERY_DEBUG");
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private File file;
    public static final String RESOURCE_SUFFIX = ".resource";
    static final String TEMP_SUFFIX = ".temp";
    public static final byte VERSION_NUMBER = 1;
    protected TsFileResource prev;
    protected TsFileResource next;
    protected ITimeIndex timeIndex;
    private byte timeIndexType;
    private ModificationFile modFile;
    private ModificationFile compactionModFile;
    protected volatile boolean closed = false;
    private volatile boolean deleted = false;
    volatile boolean isCompacting = false;
    volatile boolean compactionCandidate = false;
    private TsFileLock tsFileLock = new TsFileLock();
    private final Random random = new Random();
    private boolean isSeq;
    private FSFactory fsFactory = FSFactoryProducer.getFSFactory();
    private List<TsFileResource> upgradedResources;
    private VirtualStorageGroupProcessor.UpgradeTsFileResourceCallBack upgradeTsFileResourceCallBack;
    private VirtualStorageGroupProcessor.SettleTsFileCallBack settleTsFileCallBack;
    protected long maxPlanIndex = Long.MIN_VALUE;
    protected long minPlanIndex = Long.MAX_VALUE;
    private long version = 0L;
    private long ramSize;
    private long tsFileSize = -1L;
    private TsFileProcessor processor;
    private Map<PartialPath, List<IChunkMetadata>> pathToChunkMetadataListMap = new HashMap<PartialPath, List<IChunkMetadata>>();
    private Map<PartialPath, List<ReadOnlyMemChunk>> pathToReadOnlyMemChunkMap = new HashMap<PartialPath, List<ReadOnlyMemChunk>>();
    private Map<PartialPath, ITimeSeriesMetadata> pathToTimeSeriesMetadataMap = new HashMap<PartialPath, ITimeSeriesMetadata>();
    private TsFileResource originTsFileResource;

    public TsFileResource() {
    }

    public TsFileResource(TsFileResource other) throws IOException {
        this.file = other.file;
        this.processor = other.processor;
        this.timeIndex = other.timeIndex;
        this.timeIndexType = other.timeIndexType;
        this.modFile = other.modFile;
        this.closed = other.closed;
        this.deleted = other.deleted;
        this.isCompacting = other.isCompacting;
        this.pathToChunkMetadataListMap = other.pathToChunkMetadataListMap;
        this.pathToReadOnlyMemChunkMap = other.pathToReadOnlyMemChunkMap;
        this.pathToTimeSeriesMetadataMap = other.pathToTimeSeriesMetadataMap;
        this.tsFileLock = other.tsFileLock;
        this.fsFactory = other.fsFactory;
        this.maxPlanIndex = other.maxPlanIndex;
        this.minPlanIndex = other.minPlanIndex;
        this.version = FilePathUtils.splitAndGetTsFileVersion((String)this.file.getName());
        this.tsFileSize = other.tsFileSize;
    }

    public TsFileResource(File file) {
        this.file = file;
        this.version = FilePathUtils.splitAndGetTsFileVersion((String)this.file.getName());
        this.timeIndex = CONFIG.getTimeIndexLevel().getTimeIndex();
        this.timeIndexType = (byte)CONFIG.getTimeIndexLevel().ordinal();
    }

    public TsFileResource(File file, TsFileProcessor processor) {
        this.file = file;
        this.version = FilePathUtils.splitAndGetTsFileVersion((String)this.file.getName());
        this.timeIndex = CONFIG.getTimeIndexLevel().getTimeIndex();
        this.timeIndexType = (byte)CONFIG.getTimeIndexLevel().ordinal();
        this.processor = processor;
    }

    public TsFileResource(PartialPath path, List<ReadOnlyMemChunk> readOnlyMemChunk, List<IChunkMetadata> chunkMetadataList, TsFileResource originTsFileResource) throws IOException {
        this.file = originTsFileResource.file;
        this.timeIndex = originTsFileResource.timeIndex;
        this.timeIndexType = originTsFileResource.timeIndexType;
        this.pathToReadOnlyMemChunkMap.put(path, readOnlyMemChunk);
        this.pathToChunkMetadataListMap.put(path, chunkMetadataList);
        this.originTsFileResource = originTsFileResource;
        this.version = originTsFileResource.version;
    }

    public TsFileResource(Map<PartialPath, List<ReadOnlyMemChunk>> pathToReadOnlyMemChunkMap, Map<PartialPath, List<IChunkMetadata>> pathToChunkMetadataListMap, TsFileResource originTsFileResource) throws IOException {
        this.file = originTsFileResource.file;
        this.timeIndex = originTsFileResource.timeIndex;
        this.timeIndexType = originTsFileResource.timeIndexType;
        this.pathToReadOnlyMemChunkMap = pathToReadOnlyMemChunkMap;
        this.pathToChunkMetadataListMap = pathToChunkMetadataListMap;
        this.generatePathToTimeSeriesMetadataMap();
        this.originTsFileResource = originTsFileResource;
        this.version = originTsFileResource.version;
    }

    public TsFileResource(File file, Map<String, Integer> deviceToIndex, long[] startTimes, long[] endTimes) {
        this.file = file;
        this.timeIndex = new DeviceTimeIndex(deviceToIndex, startTimes, endTimes);
        this.timeIndexType = 1;
    }

    public synchronized void serialize() throws IOException {
        try (BufferedOutputStream outputStream = this.fsFactory.getBufferedOutputStream(this.file + RESOURCE_SUFFIX + TEMP_SUFFIX);){
            ReadWriteIOUtils.write((byte)1, (OutputStream)outputStream);
            ReadWriteIOUtils.write((byte)this.timeIndexType, (OutputStream)outputStream);
            this.timeIndex.serialize(outputStream);
            ReadWriteIOUtils.write((long)this.maxPlanIndex, (OutputStream)outputStream);
            ReadWriteIOUtils.write((long)this.minPlanIndex, (OutputStream)outputStream);
            if (this.modFile != null && this.modFile.exists()) {
                String modFileName = new File(this.modFile.getFilePath()).getName();
                ReadWriteIOUtils.write((String)modFileName, (OutputStream)outputStream);
            }
        }
        File src = this.fsFactory.getFile(this.file + RESOURCE_SUFFIX + TEMP_SUFFIX);
        File dest = this.fsFactory.getFile(this.file + RESOURCE_SUFFIX);
        this.fsFactory.deleteIfExists(dest);
        this.fsFactory.moveFile(src, dest);
    }

    public void deserialize() throws IOException {
        try (BufferedInputStream inputStream = this.fsFactory.getBufferedInputStream(this.file + RESOURCE_SUFFIX);){
            String modFileName;
            this.timeIndexType = ReadWriteIOUtils.readBytes((InputStream)inputStream, (int)2)[1];
            this.timeIndex = TimeIndexLevel.valueOf(this.timeIndexType).getTimeIndex().deserialize(inputStream);
            this.maxPlanIndex = ReadWriteIOUtils.readLong((InputStream)inputStream);
            this.minPlanIndex = ReadWriteIOUtils.readLong((InputStream)inputStream);
            if (((InputStream)inputStream).available() > 0 && (modFileName = ReadWriteIOUtils.readString((InputStream)inputStream)) != null) {
                File modF = new File(this.file.getParentFile(), modFileName);
                this.modFile = new ModificationFile(modF.getPath());
            }
        }
        if (this.timeIndexType == 0) {
            this.timeIndexType = (byte)2;
            this.serialize();
        }
    }

    public void deserializeFromOldFile() throws IOException {
        try (BufferedInputStream inputStream = this.fsFactory.getBufferedInputStream(this.file + RESOURCE_SUFFIX);){
            String modFileName;
            int i;
            int size = ReadWriteIOUtils.readInt((InputStream)inputStream);
            HashMap<String, Integer> deviceMap = new HashMap<String, Integer>();
            long[] startTimesArray = new long[size];
            long[] endTimesArray = new long[size];
            for (i = 0; i < size; ++i) {
                String path = ReadWriteIOUtils.readString((InputStream)inputStream);
                long time = ReadWriteIOUtils.readLong((InputStream)inputStream);
                deviceMap.put(path.intern(), i);
                startTimesArray[i] = time;
            }
            size = ReadWriteIOUtils.readInt((InputStream)inputStream);
            for (i = 0; i < size; ++i) {
                long time;
                ReadWriteIOUtils.readString((InputStream)inputStream);
                endTimesArray[i] = time = ReadWriteIOUtils.readLong((InputStream)inputStream);
            }
            this.timeIndexType = 1;
            this.timeIndex = new DeviceTimeIndex(deviceMap, startTimesArray, endTimesArray);
            if (((InputStream)inputStream).available() > 0) {
                int versionSize = ReadWriteIOUtils.readInt((InputStream)inputStream);
                for (int i2 = 0; i2 < versionSize; ++i2) {
                    ReadWriteIOUtils.readLong((InputStream)inputStream);
                }
            }
            if (((InputStream)inputStream).available() > 0 && (modFileName = ReadWriteIOUtils.readString((InputStream)inputStream)) != null) {
                File modF = new File(this.file.getParentFile(), modFileName);
                this.modFile = new ModificationFile(modF.getPath());
            }
        }
    }

    public void updateStartTime(String device, long time) {
        this.timeIndex.updateStartTime(device, time);
    }

    public void updateEndTime(String device, long time) {
        this.timeIndex.updateEndTime(device, time);
    }

    public boolean resourceFileExists() {
        return this.fsFactory.getFile(this.file + RESOURCE_SUFFIX).exists();
    }

    public List<IChunkMetadata> getChunkMetadataList(PartialPath seriesPath) {
        return new ArrayList<IChunkMetadata>((Collection)this.pathToChunkMetadataListMap.get(seriesPath));
    }

    public List<ReadOnlyMemChunk> getReadOnlyMemChunk(PartialPath seriesPath) {
        return this.pathToReadOnlyMemChunkMap.get(seriesPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModificationFile getModFile() {
        if (this.modFile == null) {
            TsFileResource tsFileResource = this;
            synchronized (tsFileResource) {
                if (this.modFile == null) {
                    this.modFile = ModificationFile.getNormalMods(this);
                }
            }
        }
        return this.modFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModificationFile getCompactionModFile() {
        if (this.compactionModFile == null) {
            TsFileResource tsFileResource = this;
            synchronized (tsFileResource) {
                if (this.compactionModFile == null) {
                    this.compactionModFile = ModificationFile.getCompactionMods(this);
                }
            }
        }
        return this.compactionModFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetModFile() {
        if (this.modFile != null) {
            TsFileResource tsFileResource = this;
            synchronized (tsFileResource) {
                this.modFile = null;
            }
        }
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getTsFile() {
        return this.file;
    }

    public String getTsFilePath() {
        return this.file.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTsFileSize() {
        if (this.closed) {
            if (this.tsFileSize == -1L) {
                TsFileResource tsFileResource = this;
                synchronized (tsFileResource) {
                    if (this.tsFileSize == -1L) {
                        this.tsFileSize = this.file.length();
                    }
                }
            }
            return this.tsFileSize;
        }
        return this.file.length();
    }

    public long getStartTime(String deviceId) {
        return this.timeIndex.getStartTime(deviceId);
    }

    public long getEndTime(String deviceId) {
        return this.timeIndex.getEndTime(deviceId);
    }

    public long getOrderTime(String deviceId, boolean ascending) {
        return ascending ? this.getStartTime(deviceId) : this.getEndTime(deviceId);
    }

    public long getFileStartTime() {
        return this.timeIndex.getMinStartTime();
    }

    public long getFileEndTime() {
        return this.timeIndex.getMaxEndTime();
    }

    public Set<String> getDevices() {
        return this.timeIndex.getDevices(this.file.getPath(), this);
    }

    public boolean mayContainsDevice(String device) {
        return this.timeIndex.mayContainsDevice(device);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() throws IOException {
        this.closed = true;
        if (this.modFile != null) {
            this.modFile.close();
            this.modFile = null;
        }
        if (this.compactionModFile != null) {
            this.compactionModFile.close();
            this.compactionModFile = null;
        }
        this.processor = null;
        this.pathToChunkMetadataListMap = null;
        this.pathToReadOnlyMemChunkMap = null;
        this.pathToTimeSeriesMetadataMap = null;
        this.timeIndex.close();
    }

    TsFileProcessor getProcessor() {
        return this.processor;
    }

    public void writeLock() {
        if (this.originTsFileResource == null) {
            this.tsFileLock.writeLock();
        } else {
            this.originTsFileResource.writeLock();
        }
    }

    public void writeUnlock() {
        if (this.originTsFileResource == null) {
            this.tsFileLock.writeUnlock();
        } else {
            this.originTsFileResource.writeUnlock();
        }
    }

    public void readLock() {
        if (this.originTsFileResource == null) {
            this.tsFileLock.readLock();
        } else {
            this.originTsFileResource.readLock();
        }
    }

    public void readUnlock() {
        if (this.originTsFileResource == null) {
            this.tsFileLock.readUnlock();
        } else {
            this.originTsFileResource.readUnlock();
        }
    }

    public boolean tryWriteLock() {
        return this.tsFileLock.tryWriteLock();
    }

    public boolean tryReadLock() {
        return this.tsFileLock.tryReadLock();
    }

    void doUpgrade() {
        UpgradeSevice.getINSTANCE().submitUpgradeTask(new UpgradeTask(this));
    }

    public void removeModFile() throws IOException {
        this.getModFile().remove();
        this.modFile = null;
    }

    public boolean remove() {
        try {
            this.fsFactory.deleteIfExists(this.file);
        }
        catch (IOException e) {
            LOGGER.error("TsFile {} cannot be deleted: {}", (Object)this.file, (Object)e.getMessage());
            return false;
        }
        if (!this.removeResourceFile()) {
            return false;
        }
        try {
            this.fsFactory.deleteIfExists(this.fsFactory.getFile(this.file.getPath() + ".mods"));
        }
        catch (IOException e) {
            LOGGER.error("ModificationFile {} cannot be deleted: {}", (Object)this.file, (Object)e.getMessage());
            return false;
        }
        return true;
    }

    public boolean removeResourceFile() {
        try {
            this.fsFactory.deleteIfExists(this.fsFactory.getFile(this.file.getPath() + RESOURCE_SUFFIX));
            this.fsFactory.deleteIfExists(this.fsFactory.getFile(this.file.getPath() + RESOURCE_SUFFIX + TEMP_SUFFIX));
        }
        catch (IOException e) {
            LOGGER.error("TsFileResource {} cannot be deleted: {}", (Object)this.file, (Object)e.getMessage());
            return false;
        }
        return true;
    }

    void moveTo(File targetDir) {
        this.fsFactory.moveFile(this.file, this.fsFactory.getFile(targetDir, this.file.getName()));
        this.fsFactory.moveFile(this.fsFactory.getFile(this.file.getPath() + RESOURCE_SUFFIX), this.fsFactory.getFile(targetDir, this.file.getName() + RESOURCE_SUFFIX));
        File originModFile = this.fsFactory.getFile(this.file.getPath() + ".mods");
        if (originModFile.exists()) {
            this.fsFactory.moveFile(originModFile, this.fsFactory.getFile(targetDir, this.file.getName() + ".mods"));
        }
    }

    public String toString() {
        return String.format("file is %s, compactionCandidate: %s, compacting: %s", this.file.toString(), this.compactionCandidate, this.isCompacting);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TsFileResource that = (TsFileResource)o;
        return Objects.equals(this.file, that.file);
    }

    public int hashCode() {
        return Objects.hash(this.file);
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean isCompacting() {
        return this.isCompacting;
    }

    public void setCompacting(boolean compacting) {
        this.isCompacting = compacting;
    }

    public boolean isCompactionCandidate() {
        return this.compactionCandidate;
    }

    public void setCompactionCandidate(boolean compactionCandidate) {
        this.compactionCandidate = compactionCandidate;
    }

    public boolean stillLives(long timeLowerBound) {
        return !this.isClosed() || this.timeIndex.stillLives(timeLowerBound);
    }

    public boolean isDeviceIdExist(String deviceId) {
        return this.timeIndex.checkDeviceIdExist(deviceId);
    }

    public boolean isSatisfied(String deviceId, Filter timeFilter, boolean isSeq, long ttl, boolean debug) {
        long endTime;
        if (deviceId == null) {
            return this.isSatisfied(timeFilter, isSeq, ttl, debug);
        }
        if (!this.mayContainsDevice(deviceId)) {
            if (debug) {
                DEBUG_LOGGER.info("Path: {} file {} is not satisfied because of no device!", (Object)deviceId, (Object)this.file);
            }
            return false;
        }
        long startTime = this.getStartTime(deviceId);
        long l = endTime = this.closed || !isSeq ? this.getEndTime(deviceId) : Long.MAX_VALUE;
        if (!this.isAlive(endTime, ttl)) {
            if (debug) {
                DEBUG_LOGGER.info("file {} is not satisfied because of ttl!", (Object)this.file);
            }
            return false;
        }
        if (timeFilter != null) {
            boolean res = timeFilter.satisfyStartEndTime(startTime, endTime);
            if (debug && !res) {
                DEBUG_LOGGER.info("Path: {} file {} is not satisfied because of time filter!", (Object)deviceId, (Object)this.fsFactory);
            }
            return res;
        }
        return true;
    }

    private boolean isSatisfied(Filter timeFilter, boolean isSeq, long ttl, boolean debug) {
        long endTime;
        long startTime = this.getFileStartTime();
        long l = endTime = this.closed || !isSeq ? this.getFileEndTime() : Long.MAX_VALUE;
        if (!this.isAlive(endTime, ttl)) {
            if (debug) {
                DEBUG_LOGGER.info("file {} is not satisfied because of ttl!", (Object)this.file);
            }
            return false;
        }
        if (timeFilter != null) {
            boolean res = timeFilter.satisfyStartEndTime(startTime, endTime);
            if (debug && !res) {
                DEBUG_LOGGER.info("Path: file {} is not satisfied because of time filter!", (Object)this.fsFactory);
            }
            return res;
        }
        return true;
    }

    public boolean isSatisfied(String deviceId, Filter timeFilter, TsFileFilter fileFilter, boolean isSeq, boolean debug) {
        long endTime;
        if (fileFilter != null && fileFilter.fileNotSatisfy(this)) {
            if (debug) {
                DEBUG_LOGGER.info("Path: {} file {} is not satisfied because of fileFilter!", (Object)deviceId, (Object)this.file);
            }
            return false;
        }
        if (!this.mayContainsDevice(deviceId)) {
            if (debug) {
                DEBUG_LOGGER.info("Path: {} file {} is not satisfied because of no device!", (Object)deviceId, (Object)this.file);
            }
            return false;
        }
        long startTime = this.getStartTime(deviceId);
        long l = endTime = this.closed || !isSeq ? this.getEndTime(deviceId) : Long.MAX_VALUE;
        if (timeFilter != null) {
            boolean res = timeFilter.satisfyStartEndTime(startTime, endTime);
            if (debug && !res) {
                DEBUG_LOGGER.info("Path: {} file {} is not satisfied because of time filter!", (Object)deviceId, (Object)this.fsFactory);
            }
            return res;
        }
        return true;
    }

    private boolean isAlive(long time, long dataTTL) {
        return dataTTL == Long.MAX_VALUE || System.currentTimeMillis() - time <= dataTTL;
    }

    public void setProcessor(TsFileProcessor processor) {
        this.processor = processor;
    }

    public ITimeSeriesMetadata getTimeSeriesMetadata(PartialPath seriesPath) {
        if (this.pathToTimeSeriesMetadataMap.containsKey(seriesPath)) {
            return this.pathToTimeSeriesMetadataMap.get(seriesPath);
        }
        return null;
    }

    public void setTimeSeriesMetadata(PartialPath path, ITimeSeriesMetadata timeSeriesMetadata) {
        this.pathToTimeSeriesMetadataMap.put(path, timeSeriesMetadata);
    }

    public void setUpgradedResources(List<TsFileResource> upgradedResources) {
        this.upgradedResources = upgradedResources;
    }

    public List<TsFileResource> getUpgradedResources() {
        return this.upgradedResources;
    }

    public void setUpgradeTsFileResourceCallBack(VirtualStorageGroupProcessor.UpgradeTsFileResourceCallBack upgradeTsFileResourceCallBack) {
        this.upgradeTsFileResourceCallBack = upgradeTsFileResourceCallBack;
    }

    public VirtualStorageGroupProcessor.UpgradeTsFileResourceCallBack getUpgradeTsFileResourceCallBack() {
        return this.upgradeTsFileResourceCallBack;
    }

    public VirtualStorageGroupProcessor.SettleTsFileCallBack getSettleTsFileCallBack() {
        return this.settleTsFileCallBack;
    }

    public void setSettleTsFileCallBack(VirtualStorageGroupProcessor.SettleTsFileCallBack settleTsFileCallBack) {
        this.settleTsFileCallBack = settleTsFileCallBack;
    }

    public long getTimePartition() {
        return this.timeIndex.getTimePartition(this.file.getAbsolutePath());
    }

    public long getTimePartitionWithCheck() throws PartitionViolationException {
        return this.timeIndex.getTimePartitionWithCheck(this.file.toString());
    }

    public boolean isSpanMultiTimePartitions() {
        return this.timeIndex.isSpanMultiTimePartitions();
    }

    public TsFileResource createHardlink() {
        TsFileResource newResource;
        if (!this.file.exists()) {
            return null;
        }
        try {
            newResource = new TsFileResource(this);
        }
        catch (IOException e) {
            LOGGER.error("Cannot create hardlink for {}", (Object)this.file, (Object)e);
            return null;
        }
        while (true) {
            String hardlinkSuffix = "." + System.currentTimeMillis() + "_" + this.random.nextLong();
            File hardlink = new File(this.file.getAbsolutePath() + hardlinkSuffix);
            try {
                Files.createLink(Paths.get(hardlink.getAbsolutePath(), new String[0]), Paths.get(this.file.getAbsolutePath(), new String[0]));
                newResource.setFile(hardlink);
                if (this.modFile == null || !this.modFile.exists()) break;
                newResource.setModFile(this.modFile.createHardlink());
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                continue;
            }
            catch (IOException e) {
                LOGGER.error("Cannot create hardlink for {}", (Object)this.file, (Object)e);
                return null;
            }
            break;
        }
        return newResource;
    }

    public synchronized void setModFile(ModificationFile modFile) {
        this.modFile = modFile;
    }

    public long calculateRamSize() {
        this.ramSize = this.timeIndex.calculateRamSize();
        return this.ramSize;
    }

    public void delete() throws IOException {
        if (this.file.exists()) {
            Files.delete(this.file.toPath());
            Files.delete(FSFactoryProducer.getFSFactory().getFile(this.file.toPath() + RESOURCE_SUFFIX).toPath());
        }
    }

    public long getMaxPlanIndex() {
        return this.maxPlanIndex;
    }

    public long getMinPlanIndex() {
        return this.minPlanIndex;
    }

    public void updatePlanIndexes(long planIndex) {
        if (planIndex == Long.MIN_VALUE || planIndex == Long.MAX_VALUE) {
            return;
        }
        this.maxPlanIndex = Math.max(this.maxPlanIndex, planIndex);
        this.minPlanIndex = Math.min(this.minPlanIndex, planIndex);
        if (this.closed) {
            try {
                this.serialize();
            }
            catch (IOException e) {
                LOGGER.error("Cannot serialize TsFileResource {} when updating plan index {}-{}", new Object[]{this, this.maxPlanIndex, planIndex});
            }
        }
    }

    public static int getInnerCompactionCount(String fileName) throws IOException {
        TsFileNameGenerator.TsFileName tsFileName = TsFileNameGenerator.getTsFileName(fileName);
        return tsFileName.getInnerCompactionCnt();
    }

    public void updatePlanIndexes(TsFileResource another) {
        this.maxPlanIndex = Math.max(this.maxPlanIndex, another.maxPlanIndex);
        this.minPlanIndex = Math.min(this.minPlanIndex, another.minPlanIndex);
    }

    public boolean isPlanIndexOverlap(TsFileResource another) {
        return another.maxPlanIndex > this.minPlanIndex && another.minPlanIndex < this.maxPlanIndex;
    }

    public boolean isPlanRangeCovers(TsFileResource another) {
        return this.minPlanIndex < another.minPlanIndex && another.maxPlanIndex < this.maxPlanIndex;
    }

    public void setMaxPlanIndex(long maxPlanIndex) {
        this.maxPlanIndex = maxPlanIndex;
    }

    public void setMinPlanIndex(long minPlanIndex) {
        this.minPlanIndex = minPlanIndex;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public long getVersion() {
        return this.version;
    }

    public void setTimeIndex(ITimeIndex timeIndex) {
        this.timeIndex = timeIndex;
    }

    public static int compareFileName(TsFileResource o1, TsFileResource o2) {
        long ver2;
        String[] items1 = o1.getTsFile().getName().replace(".tsfile", "").split("-");
        String[] items2 = o2.getTsFile().getName().replace(".tsfile", "").split("-");
        long ver1 = Long.parseLong(items1[0]);
        int cmp = Long.compare(ver1, ver2 = Long.parseLong(items2[0]));
        if (cmp == 0) {
            int cmpVersion = Long.compare(Long.parseLong(items1[1]), Long.parseLong(items2[1]));
            if (cmpVersion == 0) {
                int cmpInnerCompact = Long.compare(Long.parseLong(items1[2]), Long.parseLong(items2[2]));
                if (cmpInnerCompact == 0) {
                    return Long.compare(Long.parseLong(items1[3]), Long.parseLong(items2[3]));
                }
                return cmpInnerCompact;
            }
            return cmpVersion;
        }
        return cmp;
    }

    public void setSeq(boolean seq) {
        this.isSeq = seq;
    }

    public boolean isSeq() {
        return this.isSeq;
    }

    public int compareIndexDegradePriority(TsFileResource tsFileResource) {
        int cmp = this.timeIndex.compareDegradePriority(tsFileResource.timeIndex);
        return cmp == 0 ? this.file.getAbsolutePath().compareTo(tsFileResource.file.getAbsolutePath()) : cmp;
    }

    public byte getTimeIndexType() {
        return this.timeIndexType;
    }

    public void setTimeIndexType(byte type) {
        this.timeIndexType = type;
    }

    public long getRamSize() {
        return this.ramSize;
    }

    public long degradeTimeIndex() {
        TimeIndexLevel timeIndexLevel = TimeIndexLevel.valueOf(this.timeIndexType);
        if (timeIndexLevel == TimeIndexLevel.FILE_TIME_INDEX) {
            return 0L;
        }
        long startTime = this.timeIndex.getMinStartTime();
        long endTime = this.timeIndex.getMaxEndTime();
        this.timeIndex = new FileTimeIndex(startTime, endTime);
        this.timeIndexType = (byte)2;
        return this.ramSize - this.timeIndex.calculateRamSize();
    }

    private void generatePathToTimeSeriesMetadataMap() throws IOException {
        for (PartialPath path : this.pathToChunkMetadataListMap.keySet()) {
            this.pathToTimeSeriesMetadataMap.put(path, path.generateTimeSeriesMetadata(this.pathToReadOnlyMemChunkMap.get(path), this.pathToChunkMetadataListMap.get(path)));
        }
    }

    public boolean isFileInList() {
        return this.prev != null || this.next != null;
    }
}

