/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.memtable;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.engine.memtable.IWritableMemChunkGroup;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.idtable.entry.IDeviceID;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;

public interface IMemTable {
    public Map<IDeviceID, IWritableMemChunkGroup> getMemTableMap();

    public void write(IDeviceID var1, List<IMeasurementSchema> var2, long var3, Object[] var5);

    public void writeAlignedRow(IDeviceID var1, List<IMeasurementSchema> var2, long var3, Object[] var5);

    public void write(InsertTabletPlan var1, int var2, int var3);

    public void writeAlignedTablet(InsertTabletPlan var1, int var2, int var3);

    public long size();

    public long memSize();

    public void addTVListRamCost(long var1);

    public void releaseTVListRamCost(long var1);

    public long getTVListsRamCost();

    public boolean reachTotalPointNumThreshold();

    public int getSeriesNumber();

    public long getTotalPointsNum();

    public void insert(InsertRowPlan var1);

    public void insertAlignedRow(InsertRowPlan var1);

    public void insertTablet(InsertTabletPlan var1, int var2, int var3) throws WriteProcessException;

    public void insertAlignedTablet(InsertTabletPlan var1, int var2, int var3) throws WriteProcessException;

    public ReadOnlyMemChunk query(PartialPath var1, long var2, List<Pair<Modification, IMemTable>> var4) throws IOException, QueryProcessException, MetadataException;

    public void clear();

    public boolean isEmpty();

    public void delete(PartialPath var1, PartialPath var2, long var3, long var5);

    public IMemTable copy();

    public boolean isSignalMemTable();

    public void setShouldFlush();

    public boolean shouldFlush();

    public void release();

    public boolean checkIfChunkDoesNotExist(IDeviceID var1, String var2);

    public long getCurrentTVListSize(IDeviceID var1, String var2);

    public void addTextDataSize(long var1);

    public void releaseTextDataSize(long var1);

    public long getMaxPlanIndex();

    public long getMinPlanIndex();

    public long getCreatedTime();
}

