/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.task;

import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.directories.DirectoryManager;
import org.apache.iotdb.db.engine.compaction.utils.log.CompactionLogger;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionRecoverTask {
    private static final Logger logger = LoggerFactory.getLogger((String)"COMPACTION");
    private TsFileManager tsFileManager;
    private String logicalStorageGroupName;
    private String virtualStorageGroupId;

    public CompactionRecoverTask(TsFileManager tsFileManager, String logicalStorageGroupName, String virtualStorageGroupId) {
        this.tsFileManager = tsFileManager;
        this.logicalStorageGroupName = logicalStorageGroupName;
        this.virtualStorageGroupId = virtualStorageGroupId;
    }

    public void recoverCrossSpaceCompaction() throws Exception {
        logger.info("recovering cross compaction");
        this.recoverCrossCompactionFromOldVersion();
        this.recoverCrossCompaction();
        logger.info("try to synchronize CompactionScheduler");
    }

    private void recoverCrossCompaction() throws Exception {
        List<String> sequenceDirs = DirectoryManager.getInstance().getAllSequenceFileFolders();
        for (String dir : sequenceDirs) {
            File storageGroupDir = new File(dir + File.separator + this.logicalStorageGroupName + File.separator + this.virtualStorageGroupId);
            if (!storageGroupDir.exists()) {
                return;
            }
            File[] timePartitionDirs = storageGroupDir.listFiles();
            if (timePartitionDirs == null) {
                return;
            }
            for (File timePartitionDir : timePartitionDirs) {
                File[] compactionLogs;
                if (!timePartitionDir.isDirectory() || !Pattern.compile("[0-9]*").matcher(timePartitionDir.getName()).matches()) continue;
                for (File compactionLog : compactionLogs = CompactionLogger.findCrossSpaceCompactionLogs(timePartitionDir.getPath())) {
                    logger.info("calling cross compaction task");
                    IoTDBDescriptor.getInstance().getConfig().getCrossCompactionStrategy().getCompactionRecoverTask(this.logicalStorageGroupName, this.virtualStorageGroupId, Long.parseLong(timePartitionDir.getName()), compactionLog, this.tsFileManager).call();
                }
            }
        }
    }

    private void recoverCrossCompactionFromOldVersion() throws Exception {
        File mergeLogFromOldVersion = new File(this.tsFileManager.getStorageGroupDir() + File.separator + "merge.log");
        if (mergeLogFromOldVersion.exists()) {
            logger.info("calling cross compaction task to recover from previous version.");
            IoTDBDescriptor.getInstance().getConfig().getCrossCompactionStrategy().getCompactionRecoverTask(this.logicalStorageGroupName, this.virtualStorageGroupId, 0L, mergeLogFromOldVersion, this.tsFileManager).call();
        }
    }
}

