/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.task;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.engine.compaction.CompactionTaskManager;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.task.RewriteCrossCompactionRecoverTask;
import org.apache.iotdb.db.engine.compaction.inner.sizetiered.SizeTieredCompactionRecoverTask;
import org.apache.iotdb.db.service.metrics.Metric;
import org.apache.iotdb.db.service.metrics.MetricsService;
import org.apache.iotdb.db.service.metrics.Tag;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCompactionTask
implements Callable<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    protected String fullStorageGroupName;
    protected long timePartition;
    protected final AtomicInteger currentTaskNum;

    public AbstractCompactionTask(String fullStorageGroupName, long timePartition, AtomicInteger currentTaskNum) {
        this.fullStorageGroupName = fullStorageGroupName;
        this.timePartition = timePartition;
        this.currentTaskNum = currentTaskNum;
    }

    public abstract void setSourceFilesToCompactionCandidate();

    protected abstract void doCompaction() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        long startTime = System.currentTimeMillis();
        this.currentTaskNum.incrementAndGet();
        try {
            this.doCompaction();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (!(this instanceof RewriteCrossCompactionRecoverTask) && !(this instanceof SizeTieredCompactionRecoverTask)) {
                CompactionTaskManager.getInstance().removeRunningTaskFromList(this);
            }
            this.currentTaskNum.decrementAndGet();
        }
        if (MetricConfigDescriptor.getInstance().getMetricConfig().getEnableMetric().booleanValue()) {
            MetricsService.getInstance().getMetricManager().timer(System.currentTimeMillis() - startTime, TimeUnit.MILLISECONDS, Metric.COST_TASK.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "compaction"});
        }
        return null;
    }

    public String getFullStorageGroupName() {
        return this.fullStorageGroupName;
    }

    public long getTimePartition() {
        return this.timePartition;
    }

    public abstract boolean equalsOtherTask(AbstractCompactionTask var1);

    public abstract boolean checkValidAndSetMerging();

    public boolean equals(Object other) {
        if (other instanceof AbstractCompactionTask) {
            return this.equalsOtherTask((AbstractCompactionTask)other);
        }
        return false;
    }

    public abstract void resetCompactionCandidateStatusForAllSourceFiles();
}

