/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.inner.sizetiered;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.engine.compaction.CompactionUtils;
import org.apache.iotdb.db.engine.compaction.inner.AbstractInnerSpaceCompactionTask;
import org.apache.iotdb.db.engine.compaction.inner.InnerSpaceCompactionExceptionHandler;
import org.apache.iotdb.db.engine.compaction.inner.utils.InnerSpaceCompactionUtils;
import org.apache.iotdb.db.engine.compaction.task.AbstractCompactionTask;
import org.apache.iotdb.db.engine.compaction.utils.log.CompactionLogger;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileNameGenerator;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SizeTieredCompactionTask
extends AbstractInnerSpaceCompactionTask {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    protected TsFileResourceList tsFileResourceList;
    protected TsFileManager tsFileManager;
    protected boolean[] isHoldingReadLock;
    protected boolean[] isHoldingWriteLock;

    public SizeTieredCompactionTask(String logicalStorageGroupName, String virtualStorageGroupName, long timePartition, TsFileManager tsFileManager, List<TsFileResource> selectedTsFileResourceList, boolean sequence, AtomicInteger currentTaskNum) {
        super(logicalStorageGroupName + "-" + virtualStorageGroupName, timePartition, currentTaskNum, sequence, selectedTsFileResourceList);
        this.tsFileManager = tsFileManager;
        this.isHoldingReadLock = new boolean[selectedTsFileResourceList.size()];
        this.isHoldingWriteLock = new boolean[selectedTsFileResourceList.size()];
        for (int i = 0; i < selectedTsFileResourceList.size(); ++i) {
            this.isHoldingWriteLock[i] = false;
            this.isHoldingReadLock[i] = false;
        }
        this.tsFileResourceList = sequence ? tsFileManager.getSequenceListByTimePartition(timePartition) : tsFileManager.getUnsequenceListByTimePartition(timePartition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCompaction() throws Exception {
        if (!this.tsFileManager.isAllowCompaction()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        String dataDirectory = ((TsFileResource)this.selectedTsFileResourceList.get(0)).getTsFile().getParent();
        TsFileResource targetTsFileResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(this.selectedTsFileResourceList, this.sequence);
        LOGGER.info("{} [Compaction] starting compaction task with {} files", (Object)this.fullStorageGroupName, (Object)this.selectedTsFileResourceList.size());
        File logFile = new File(dataDirectory + File.separator + targetTsFileResource.getTsFile().getName() + ".inner-compaction.log");
        CompactionLogger sizeTieredCompactionLogger = null;
        try {
            sizeTieredCompactionLogger = new CompactionLogger(logFile);
            sizeTieredCompactionLogger.logFiles(this.selectedTsFileResourceList, "source");
            sizeTieredCompactionLogger.logFiles(Collections.singletonList(targetTsFileResource), "target");
            LOGGER.info("{} [SizeTiredCompactionTask] Close the logger", (Object)this.fullStorageGroupName);
            sizeTieredCompactionLogger.close();
            LOGGER.info("{} [Compaction] compaction with {}", (Object)this.fullStorageGroupName, (Object)this.selectedTsFileResourceList);
            if (this.sequence) {
                InnerSpaceCompactionUtils.compact(targetTsFileResource, this.selectedTsFileResourceList);
            } else {
                CompactionUtils.compact(Collections.emptyList(), this.selectedTsFileResourceList, Collections.singletonList(targetTsFileResource));
            }
            InnerSpaceCompactionUtils.moveTargetFile(targetTsFileResource, this.fullStorageGroupName);
            LOGGER.info("{} [SizeTiredCompactionTask] start to rename mods file", (Object)this.fullStorageGroupName);
            InnerSpaceCompactionUtils.combineModsInCompaction(this.selectedTsFileResourceList, targetTsFileResource);
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException(String.format("%s [Compaction] abort", this.fullStorageGroupName));
            }
            if (this.sequence) {
                this.tsFileManager.replace(this.selectedTsFileResourceList, Collections.emptyList(), Collections.singletonList(targetTsFileResource), this.timePartition, true);
            } else {
                this.tsFileManager.replace(Collections.emptyList(), this.selectedTsFileResourceList, Collections.singletonList(targetTsFileResource), this.timePartition, false);
            }
            LOGGER.info("{} [Compaction] Compacted target files, try to get the write lock of source files", (Object)this.fullStorageGroupName);
            for (int i = 0; i < this.selectedTsFileResourceList.size(); ++i) {
                ((TsFileResource)this.selectedTsFileResourceList.get(i)).readUnlock();
                this.isHoldingReadLock[i] = false;
                ((TsFileResource)this.selectedTsFileResourceList.get(i)).writeLock();
                this.isHoldingWriteLock[i] = true;
            }
            if (targetTsFileResource.getTsFile().length() < (long)"TsFile".getBytes().length * 2L + 1L) {
                throw new RuntimeException(String.format("target file %s is smaller than magic string and version number size", targetTsFileResource));
            }
            LOGGER.info("{} [Compaction] compaction finish, start to delete old files", (Object)this.fullStorageGroupName);
            InnerSpaceCompactionUtils.deleteTsFilesInDisk(this.selectedTsFileResourceList, this.fullStorageGroupName);
            InnerSpaceCompactionUtils.deleteModificationForSourceFile(this.selectedTsFileResourceList, this.fullStorageGroupName);
            long costTime = System.currentTimeMillis() - startTime;
            LOGGER.info("{} [SizeTiredCompactionTask] all compaction task finish, target file is {},time cost is {} s", new Object[]{this.fullStorageGroupName, targetTsFileResource.getTsFile().getName(), costTime / 1000L});
            if (logFile.exists()) {
                FileUtils.delete((File)logFile);
            }
        }
        catch (Throwable throwable) {
            LOGGER.error("{} [Compaction] Throwable is caught during execution of SizeTieredCompaction, {}", (Object)this.fullStorageGroupName, (Object)throwable);
            LOGGER.warn("{} [Compaction] Start to handle exception", (Object)this.fullStorageGroupName);
            if (sizeTieredCompactionLogger != null) {
                sizeTieredCompactionLogger.close();
            }
            InnerSpaceCompactionExceptionHandler.handleException(this.fullStorageGroupName, logFile, targetTsFileResource, this.selectedTsFileResourceList, this.tsFileManager, this.tsFileResourceList);
        }
        finally {
            this.releaseFileLocksAndResetMergingStatus(true);
        }
    }

    @Override
    public boolean equalsOtherTask(AbstractCompactionTask other) {
        if (other instanceof SizeTieredCompactionTask) {
            SizeTieredCompactionTask otherSizeTieredTask = (SizeTieredCompactionTask)other;
            return this.selectedTsFileResourceList.equals(otherSizeTieredTask.selectedTsFileResourceList);
        }
        return false;
    }

    @Override
    public boolean checkValidAndSetMerging() {
        this.selectedTsFileResourceList.forEach(x -> x.setCompactionCandidate(false));
        for (int i = 0; i < this.selectedTsFileResourceList.size(); ++i) {
            TsFileResource resource = (TsFileResource)this.selectedTsFileResourceList.get(i);
            resource.readLock();
            this.isHoldingReadLock[i] = true;
            if (!resource.isCompacting() && resource.isClosed() && resource.getTsFile().exists() && !resource.isDeleted()) continue;
            this.releaseFileLocksAndResetMergingStatus(false);
            return false;
        }
        for (TsFileResource resource : this.selectedTsFileResourceList) {
            resource.setCompacting(true);
        }
        return true;
    }

    private void releaseFileLocksAndResetMergingStatus(boolean resetCompactingStatus) {
        for (int i = 0; i < this.selectedTsFileResourceList.size(); ++i) {
            if (this.isHoldingReadLock[i]) {
                ((TsFileResource)this.selectedTsFileResourceList.get(i)).readUnlock();
            }
            if (this.isHoldingWriteLock[i]) {
                ((TsFileResource)this.selectedTsFileResourceList.get(i)).writeUnlock();
            }
            if (!resetCompactingStatus) continue;
            ((TsFileResource)this.selectedTsFileResourceList.get(i)).setCompacting(false);
        }
    }
}

