/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.utils;

import java.io.File;
import org.apache.iotdb.tsfile.utils.Pair;

public class FilePathUtils {
    private static final String PATH_SPLIT_STRING = File.separator.equals("\\") ? "\\\\" : "/";
    public static final String FILE_NAME_SEPARATOR = "-";

    private FilePathUtils() {
    }

    public static String regularizePath(String filePath) {
        if (filePath.length() > 0 && filePath.charAt(filePath.length() - 1) != File.separatorChar) {
            filePath = filePath + File.separatorChar;
        }
        return filePath;
    }

    public static String[] splitTsFilePath(String tsFileAbsolutePath) {
        return tsFileAbsolutePath.split(PATH_SPLIT_STRING);
    }

    public static String getLogicalStorageGroupName(String tsFileAbsolutePath) {
        String[] pathSegments = FilePathUtils.splitTsFilePath(tsFileAbsolutePath);
        return pathSegments[pathSegments.length - 4];
    }

    public static String getVirtualStorageGroupId(String tsFileAbsolutePath) {
        String[] pathSegments = FilePathUtils.splitTsFilePath(tsFileAbsolutePath);
        return pathSegments[pathSegments.length - 3];
    }

    public static long getTimePartitionId(String tsFileAbsolutePath) {
        String[] pathSegments = FilePathUtils.splitTsFilePath(tsFileAbsolutePath);
        return Long.parseLong(pathSegments[pathSegments.length - 2]);
    }

    public static String getTsFileNameWithoutHardLink(String tsFileAbsolutePath) {
        String[] pathSegments = FilePathUtils.splitTsFilePath(tsFileAbsolutePath);
        return pathSegments[pathSegments.length - 1].substring(0, pathSegments[pathSegments.length - 1].lastIndexOf("."));
    }

    public static String getTsFilePrefixPath(String tsFileAbsolutePath) {
        if (tsFileAbsolutePath == null) {
            return null;
        }
        String[] pathSegments = FilePathUtils.splitTsFilePath(tsFileAbsolutePath);
        int pathLength = pathSegments.length;
        return pathSegments[pathLength - 4] + File.separator + pathSegments[pathLength - 3] + File.separator + pathSegments[pathLength - 2];
    }

    public static Pair<String, Long> getLogicalSgNameAndTimePartitionIdPair(String tsFileAbsolutePath) {
        String[] pathSegments = FilePathUtils.splitTsFilePath(tsFileAbsolutePath);
        return new Pair<String, Long>(pathSegments[pathSegments.length - 4], Long.parseLong(pathSegments[pathSegments.length - 2]));
    }

    public static Pair<String, Long> getTsFilePrefixPathAndTsFileVersionPair(String tsFileAbsolutePath) {
        String[] pathSegments = FilePathUtils.splitTsFilePath(tsFileAbsolutePath);
        int pathLength = pathSegments.length;
        return new Pair<String, Long>(pathSegments[pathLength - 4] + File.separator + pathSegments[pathLength - 3] + File.separator + pathSegments[pathLength - 2], FilePathUtils.splitAndGetTsFileVersion(pathSegments[pathLength - 1]));
    }

    public static long splitAndGetTsFileVersion(String tsFileName) {
        String[] names = tsFileName.split(FILE_NAME_SEPARATOR);
        if (names.length != 4) {
            return 0L;
        }
        return Long.parseLong(names[1]);
    }
}

