/*
 * Decompiled with CFR 0.152.
 */
package me.tongfei.progressbar;

import java.text.DecimalFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import me.tongfei.progressbar.ProgressBarRenderer;
import me.tongfei.progressbar.ProgressBarStyle;
import me.tongfei.progressbar.ProgressState;
import me.tongfei.progressbar.Util;

public class DefaultProgressBarRenderer
implements ProgressBarRenderer {
    private ProgressBarStyle style;
    private String unitName;
    private long unitSize;
    private boolean isSpeedShown;
    private DecimalFormat speedFormat;
    private ChronoUnit speedUnit;

    protected DefaultProgressBarRenderer(ProgressBarStyle style, String unitName, long unitSize, boolean isSpeedShown, DecimalFormat speedFormat, ChronoUnit speedUnit) {
        this.style = style;
        this.unitName = unitName;
        this.unitSize = unitSize;
        this.isSpeedShown = isSpeedShown;
        this.speedFormat = speedFormat;
        this.speedUnit = speedUnit;
    }

    protected int progressIntegralPart(ProgressState progress, int length) {
        return (int)(progress.getNormalizedProgress() * (double)length);
    }

    protected int progressFractionalPart(ProgressState progress, int length) {
        double p = progress.getNormalizedProgress() * (double)length;
        double fraction = (p - Math.floor(p)) * (double)this.style.fractionSymbols.length();
        return (int)Math.floor(fraction);
    }

    protected String eta(ProgressState progress, Duration elapsed) {
        if (progress.max <= 0L || progress.indefinite) {
            return "?";
        }
        if (progress.current - progress.start == 0L) {
            return "?";
        }
        return Util.formatDuration(elapsed.dividedBy(progress.current - progress.start).multipliedBy(progress.max - progress.current));
    }

    protected String percentage(ProgressState progress) {
        String res = progress.max <= 0L || progress.indefinite ? "? %" : String.valueOf((int)Math.floor(100.0 * (double)progress.current / (double)progress.max)) + "%";
        return Util.repeat(' ', 4 - res.length()) + res;
    }

    protected String ratio(ProgressState progress) {
        String m = progress.indefinite ? "?" : String.valueOf(progress.max / this.unitSize);
        String c = String.valueOf(progress.current / this.unitSize);
        return Util.repeat(' ', m.length() - c.length()) + c + "/" + m + this.unitName;
    }

    protected String speed(ProgressState progress, Duration elapsed) {
        double elapsedSeconds;
        String suffix = "/s";
        double elapsedInUnit = elapsedSeconds = (double)elapsed.getSeconds();
        if (null != this.speedUnit) {
            switch (this.speedUnit) {
                case MINUTES: {
                    suffix = "/min";
                    elapsedInUnit /= 60.0;
                    break;
                }
                case HOURS: {
                    suffix = "/h";
                    elapsedInUnit /= 3600.0;
                    break;
                }
                case DAYS: {
                    suffix = "/d";
                    elapsedInUnit /= 86400.0;
                }
            }
        }
        if (elapsedSeconds == 0.0) {
            return "?" + this.unitName + suffix;
        }
        double speed = (double)(progress.current - progress.start) / elapsedInUnit;
        double speedWithUnit = speed / (double)this.unitSize;
        return this.speedFormat.format(speedWithUnit) + this.unitName + suffix;
    }

    @Override
    public String render(ProgressState progress, int maxLength) {
        Instant currTime = Instant.now();
        Duration elapsed = Duration.between(progress.startInstant, currTime);
        String prefix = progress.taskName + " " + this.percentage(progress) + " " + this.style.leftBracket;
        if (prefix.length() > maxLength) {
            prefix = prefix.substring(0, maxLength - 1);
        }
        int maxSuffixLength = Math.max(maxLength - prefix.length() - 1, 0);
        String speedString = this.isSpeedShown ? this.speed(progress, elapsed) : "";
        String suffix = this.style.rightBracket + " " + this.ratio(progress) + " (" + Util.formatDuration(elapsed) + " / " + this.eta(progress, elapsed) + ") " + speedString + progress.extraMessage;
        if (suffix.length() > maxSuffixLength) {
            suffix = suffix.substring(0, maxSuffixLength);
        }
        int length = maxLength - prefix.length() - suffix.length();
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        if (progress.indefinite) {
            int pos = (int)(progress.current % (long)length);
            sb.append(Util.repeat(this.style.space, pos));
            sb.append(this.style.block);
            sb.append(Util.repeat(this.style.space, length - pos - 1));
        } else {
            sb.append(Util.repeat(this.style.block, this.progressIntegralPart(progress, length)));
            if (progress.current < progress.max) {
                sb.append(this.style.fractionSymbols.charAt(this.progressFractionalPart(progress, length)));
                sb.append(Util.repeat(this.style.space, length - this.progressIntegralPart(progress, length) - 1));
            }
        }
        sb.append(suffix);
        return sb.toString();
    }
}

