/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.writelog.recover;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.engine.flush.MemTableFlushTask;
import org.apache.iotdb.db.engine.memtable.PrimitiveMemTable;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageGroupProcessorException;
import org.apache.iotdb.db.utils.FileLoaderUtils;
import org.apache.iotdb.db.writelog.manager.MultiFileLogNodeManager;
import org.apache.iotdb.db.writelog.recover.LogReplayer;
import org.apache.iotdb.tsfile.exception.NotCompatibleTsFileException;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileRecoverPerformer {
    private static final Logger logger = LoggerFactory.getLogger(TsFileRecoverPerformer.class);
    private final String filePath;
    private final String logNodePrefix;
    private final TsFileResource tsFileResource;
    private final boolean sequence;

    public TsFileRecoverPerformer(String logNodePrefix, TsFileResource currentTsFileResource, boolean sequence, boolean isLastFile) {
        this.filePath = currentTsFileResource.getTsFilePath();
        this.logNodePrefix = logNodePrefix;
        this.tsFileResource = currentTsFileResource;
        this.sequence = sequence;
    }

    public RestorableTsFileIOWriter recover(boolean needRedoWal, Supplier<ByteBuffer[]> supplier, Consumer<ByteBuffer[]> consumer) throws StorageGroupProcessorException {
        RestorableTsFileIOWriter restorableTsFileIOWriter;
        File file = FSFactoryProducer.getFSFactory().getFile(this.filePath);
        if (!file.exists()) {
            logger.error("TsFile {} is missing, will skip its recovery.", (Object)this.filePath);
            return null;
        }
        try {
            restorableTsFileIOWriter = new RestorableTsFileIOWriter(file, needRedoWal, false);
        }
        catch (NotCompatibleTsFileException e) {
            boolean result = file.delete();
            logger.warn("TsFile {} is incompatible. Delete it successfully {}", (Object)this.filePath, (Object)result);
            throw new StorageGroupProcessorException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new StorageGroupProcessorException(e);
        }
        if (!restorableTsFileIOWriter.hasCrashed()) {
            try {
                this.recoverResource();
                return restorableTsFileIOWriter;
            }
            catch (IOException e) {
                throw new StorageGroupProcessorException("recover the resource file failed: " + this.filePath + ".resource" + e);
            }
        }
        this.recoverResourceFromWriter(restorableTsFileIOWriter);
        if (needRedoWal) {
            this.redoLogs(restorableTsFileIOWriter, supplier);
            try {
                MultiFileLogNodeManager.getInstance().deleteNode(this.logNodePrefix + SystemFileFactory.INSTANCE.getFile(this.filePath).getName(), consumer);
            }
            catch (IOException e) {
                throw new StorageGroupProcessorException(e);
            }
        }
        return restorableTsFileIOWriter;
    }

    private void recoverResource() throws IOException {
        if (this.tsFileResource.resourceFileExists()) {
            this.recoverResourceFromFile();
        } else {
            try (TsFileSequenceReader reader = new TsFileSequenceReader(this.tsFileResource.getTsFile().getAbsolutePath());){
                FileLoaderUtils.updateTsFileResource(reader, this.tsFileResource);
            }
            this.tsFileResource.serialize();
        }
    }

    private void recoverResourceFromFile() throws IOException {
        try {
            this.tsFileResource.deserialize();
        }
        catch (Exception e) {
            logger.warn("Cannot deserialize TsFileResource {}, construct it using TsFileSequenceReader", (Object)this.tsFileResource.getTsFile(), (Object)e);
            this.recoverResourceFromReader();
        }
    }

    private void recoverResourceFromReader() throws IOException {
        try (TsFileSequenceReader reader = new TsFileSequenceReader(this.tsFileResource.getTsFile().getAbsolutePath(), true);){
            for (Map.Entry entry : reader.getAllTimeseriesMetadata().entrySet()) {
                for (TimeseriesMetadata timeseriesMetaData : (List)entry.getValue()) {
                    this.tsFileResource.updateStartTime((String)entry.getKey(), timeseriesMetaData.getStatistics().getStartTime());
                    this.tsFileResource.updateEndTime((String)entry.getKey(), timeseriesMetaData.getStatistics().getEndTime());
                }
            }
        }
        this.tsFileResource.serialize();
    }

    private void recoverResourceFromWriter(RestorableTsFileIOWriter restorableTsFileIOWriter) {
        Map deviceChunkMetaDataMap = restorableTsFileIOWriter.getDeviceChunkMetadataMap();
        for (Map.Entry entry : deviceChunkMetaDataMap.entrySet()) {
            String deviceId = (String)entry.getKey();
            List chunkMetadataList = (List)entry.getValue();
            HashMap<String, List> measurementToChunkMetadatas = new HashMap<String, List>();
            for (ChunkMetadata chunkMetadata : chunkMetadataList) {
                List list = measurementToChunkMetadatas.computeIfAbsent(chunkMetadata.getMeasurementUid(), n -> new ArrayList());
                list.add(chunkMetadata);
            }
            for (List metadataList : measurementToChunkMetadatas.values()) {
                TSDataType dataType = ((ChunkMetadata)metadataList.get(metadataList.size() - 1)).getDataType();
                for (ChunkMetadata chunkMetaData : chunkMetadataList) {
                    if (!chunkMetaData.getDataType().equals((Object)dataType)) continue;
                    this.tsFileResource.updateStartTime(deviceId, chunkMetaData.getStartTime());
                    this.tsFileResource.updateEndTime(deviceId, chunkMetaData.getEndTime());
                }
            }
        }
        this.tsFileResource.updatePlanIndexes(restorableTsFileIOWriter.getMinPlanIndex());
        this.tsFileResource.updatePlanIndexes(restorableTsFileIOWriter.getMaxPlanIndex());
    }

    private void redoLogs(RestorableTsFileIOWriter restorableTsFileIOWriter, Supplier<ByteBuffer[]> supplier) throws StorageGroupProcessorException {
        PrimitiveMemTable recoverMemTable = new PrimitiveMemTable();
        LogReplayer logReplayer = new LogReplayer(this.logNodePrefix, this.filePath, this.tsFileResource.getModFile(), this.tsFileResource, recoverMemTable, this.sequence);
        logReplayer.replayLogs(supplier);
        try {
            if (!recoverMemTable.isEmpty()) {
                MemTableFlushTask tableFlushTask = new MemTableFlushTask(recoverMemTable, restorableTsFileIOWriter, this.tsFileResource.getTsFile().getParentFile().getParentFile().getName());
                tableFlushTask.syncFlushMemTable();
                this.tsFileResource.updatePlanIndexes(recoverMemTable.getMinPlanIndex());
                this.tsFileResource.updatePlanIndexes(recoverMemTable.getMaxPlanIndex());
            }
            restorableTsFileIOWriter.endFile();
            this.tsFileResource.serialize();
        }
        catch (IOException | ExecutionException e) {
            throw new StorageGroupProcessorException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new StorageGroupProcessorException(e);
        }
    }
}

