/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class TimeValuePairUtils {
    private TimeValuePairUtils() {
    }

    public static TimeValuePair getCurrentTimeValuePair(BatchData data) {
        switch (data.getDataType()) {
            case INT32: {
                return new TimeValuePair(data.currentTime(), (TsPrimitiveType)new TsPrimitiveType.TsInt(data.getInt()));
            }
            case INT64: {
                return new TimeValuePair(data.currentTime(), (TsPrimitiveType)new TsPrimitiveType.TsLong(data.getLong()));
            }
            case FLOAT: {
                return new TimeValuePair(data.currentTime(), (TsPrimitiveType)new TsPrimitiveType.TsFloat(data.getFloat()));
            }
            case DOUBLE: {
                return new TimeValuePair(data.currentTime(), (TsPrimitiveType)new TsPrimitiveType.TsDouble(data.getDouble()));
            }
            case TEXT: {
                return new TimeValuePair(data.currentTime(), (TsPrimitiveType)new TsPrimitiveType.TsBinary(data.getBinary()));
            }
            case BOOLEAN: {
                return new TimeValuePair(data.currentTime(), (TsPrimitiveType)new TsPrimitiveType.TsBoolean(data.getBoolean()));
            }
        }
        throw new UnSupportedDataTypeException(String.valueOf(data.getDataType()));
    }

    public static void setTimeValuePair(TimeValuePair from, TimeValuePair to) {
        to.setTimestamp(from.getTimestamp());
        switch (from.getValue().getDataType()) {
            case INT32: {
                to.getValue().setInt(from.getValue().getInt());
                break;
            }
            case INT64: {
                to.getValue().setLong(from.getValue().getLong());
                break;
            }
            case FLOAT: {
                to.getValue().setFloat(from.getValue().getFloat());
                break;
            }
            case DOUBLE: {
                to.getValue().setDouble(from.getValue().getDouble());
                break;
            }
            case TEXT: {
                to.getValue().setBinary(from.getValue().getBinary());
                break;
            }
            case BOOLEAN: {
                to.getValue().setBoolean(from.getValue().getBoolean());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.valueOf(from.getValue().getDataType()));
            }
        }
    }

    public static TimeValuePair getEmptyTimeValuePair(TSDataType dataType) {
        switch (dataType) {
            case FLOAT: {
                return new TimeValuePair(0L, (TsPrimitiveType)new TsPrimitiveType.TsFloat(0.0f));
            }
            case INT32: {
                return new TimeValuePair(0L, (TsPrimitiveType)new TsPrimitiveType.TsInt(0));
            }
            case INT64: {
                return new TimeValuePair(0L, (TsPrimitiveType)new TsPrimitiveType.TsLong(0L));
            }
            case BOOLEAN: {
                return new TimeValuePair(0L, (TsPrimitiveType)new TsPrimitiveType.TsBoolean(false));
            }
            case DOUBLE: {
                return new TimeValuePair(0L, (TsPrimitiveType)new TsPrimitiveType.TsDouble(0.0));
            }
            case TEXT: {
                return new TimeValuePair(0L, (TsPrimitiveType)new TsPrimitiveType.TsBinary(new Binary("")));
            }
        }
        throw new UnsupportedOperationException("Unrecognized datatype: " + dataType);
    }
}

