/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.chunk.metadata;

import java.util.List;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.reader.chunk.metadata.DiskChunkMetadataLoader;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.read.controller.IChunkMetadataLoader;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class MemChunkMetadataLoader
implements IChunkMetadataLoader {
    private TsFileResource resource;
    private PartialPath seriesPath;
    private QueryContext context;
    private Filter timeFilter;

    public MemChunkMetadataLoader(TsFileResource resource, PartialPath seriesPath, QueryContext context, Filter timeFilter) {
        this.resource = resource;
        this.seriesPath = seriesPath;
        this.context = context;
        this.timeFilter = timeFilter;
    }

    public List<ChunkMetadata> loadChunkMetadataList(TimeseriesMetadata timeseriesMetadata) {
        List<ChunkMetadata> chunkMetadataList = this.resource.getChunkMetadataList();
        DiskChunkMetadataLoader.setDiskChunkLoader(chunkMetadataList, this.resource, this.seriesPath, this.context);
        List<ReadOnlyMemChunk> memChunks = this.resource.getReadOnlyMemChunk();
        if (memChunks != null) {
            for (ReadOnlyMemChunk readOnlyMemChunk : memChunks) {
                if (memChunks.isEmpty()) continue;
                chunkMetadataList.add(readOnlyMemChunk.getChunkMetaData());
            }
        }
        chunkMetadataList.removeIf(chunkMetaData -> this.timeFilter != null && !this.timeFilter.satisfyStartEndTime(chunkMetaData.getStartTime(), chunkMetaData.getEndTime()) || chunkMetaData.getStartTime() > chunkMetaData.getEndTime());
        for (ChunkMetadata metadata : chunkMetadataList) {
            metadata.setVersion(this.resource.getVersion());
        }
        return chunkMetadataList;
    }
}

