/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;

public class SetStorageGroupPlan
extends PhysicalPlan {
    private PartialPath path;

    public SetStorageGroupPlan() {
        super(false, Operator.OperatorType.SET_STORAGE_GROUP);
    }

    public SetStorageGroupPlan(PartialPath path) {
        super(false, Operator.OperatorType.SET_STORAGE_GROUP);
        this.path = path;
    }

    public PartialPath getPath() {
        return this.path;
    }

    public void setPath(PartialPath path) {
        this.path = path;
    }

    @Override
    public List<PartialPath> getPaths() {
        return this.path != null ? Collections.singletonList(this.path) : Collections.emptyList();
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.write((byte)PhysicalPlan.PhysicalPlanType.SET_STORAGE_GROUP.ordinal());
        this.putString(stream, this.path.getFullPath());
        stream.writeLong(this.index);
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        buffer.put((byte)PhysicalPlan.PhysicalPlanType.SET_STORAGE_GROUP.ordinal());
        this.putString(buffer, this.path.getFullPath());
        buffer.putLong(this.index);
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IllegalPathException {
        this.path = new PartialPath(this.readString(buffer));
        this.index = buffer.getLong();
    }

    public String toString() {
        return "SetStorageGroup{" + this.path + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetStorageGroupPlan that = (SetStorageGroupPlan)o;
        return Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }
}

