/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;

public class CreateFunctionPlan
extends PhysicalPlan {
    private boolean isTemporary;
    private String udfName;
    private String className;

    public CreateFunctionPlan() {
        super(false, Operator.OperatorType.CREATE_FUNCTION);
    }

    public CreateFunctionPlan(boolean isTemporary, String udfName, String className) {
        super(false, Operator.OperatorType.CREATE_FUNCTION);
        this.isTemporary = isTemporary;
        this.udfName = udfName;
        this.className = className;
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    public String getUdfName() {
        return this.udfName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setTemporary(boolean temporary) {
        this.isTemporary = temporary;
    }

    public void setUdfName(String udfName) {
        this.udfName = udfName;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @Override
    public List<PartialPath> getPaths() {
        return new ArrayList<PartialPath>();
    }

    @Override
    public void serialize(DataOutputStream outputStream) throws IOException {
        outputStream.writeByte((byte)PhysicalPlan.PhysicalPlanType.CREATE_FUNCTION.ordinal());
        outputStream.writeBoolean(this.isTemporary);
        this.putString(outputStream, this.udfName);
        this.putString(outputStream, this.className);
        outputStream.writeLong(this.index);
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IllegalPathException {
        this.isTemporary = buffer.get() == 1;
        this.udfName = this.readString(buffer);
        this.className = this.readString(buffer);
        this.index = buffer.getLong();
    }
}

