/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;

public class DeletePlan
extends PhysicalPlan {
    private long deleteStartTime;
    private long deleteEndTime;
    private List<PartialPath> paths = new ArrayList<PartialPath>();

    public DeletePlan() {
        super(false, Operator.OperatorType.DELETE);
    }

    public DeletePlan(long startTime, long endTime, PartialPath path) {
        super(false, Operator.OperatorType.DELETE);
        this.deleteStartTime = startTime;
        this.deleteEndTime = endTime;
        this.paths.add(path);
    }

    public DeletePlan(long startTime, long endTime, List<PartialPath> paths) {
        super(false, Operator.OperatorType.DELETE);
        this.deleteStartTime = startTime;
        this.deleteEndTime = endTime;
        this.paths = paths;
    }

    public long getDeleteStartTime() {
        return this.deleteStartTime;
    }

    public void setDeleteStartTime(long delTime) {
        this.deleteStartTime = delTime;
    }

    public long getDeleteEndTime() {
        return this.deleteEndTime;
    }

    public void setDeleteEndTime(long delTime) {
        this.deleteEndTime = delTime;
    }

    public void addPath(PartialPath path) {
        this.paths.add(path);
    }

    public void addPaths(List<PartialPath> paths) {
        this.paths.addAll(paths);
    }

    @Override
    public List<PartialPath> getPaths() {
        return this.paths;
    }

    @Override
    public void setPaths(List<PartialPath> paths) {
        this.paths = paths;
    }

    public int hashCode() {
        return Objects.hash(this.deleteStartTime, this.deleteEndTime, this.paths);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeletePlan that = (DeletePlan)o;
        return this.deleteStartTime == that.deleteStartTime && this.deleteEndTime == that.deleteEndTime && Objects.equals(this.paths, that.paths);
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        int type = PhysicalPlan.PhysicalPlanType.DELETE.ordinal();
        stream.writeByte((byte)type);
        stream.writeLong(this.deleteStartTime);
        stream.writeLong(this.deleteEndTime);
        stream.writeInt(this.paths.size());
        for (PartialPath path : this.paths) {
            this.putString(stream, path.getFullPath());
        }
        stream.writeLong(this.index);
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        int type = PhysicalPlan.PhysicalPlanType.DELETE.ordinal();
        buffer.put((byte)type);
        buffer.putLong(this.deleteStartTime);
        buffer.putLong(this.deleteEndTime);
        buffer.putInt(this.paths.size());
        for (PartialPath path : this.paths) {
            this.putString(buffer, path.getFullPath());
        }
        buffer.putLong(this.index);
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IllegalPathException {
        this.deleteStartTime = buffer.getLong();
        this.deleteEndTime = buffer.getLong();
        int pathSize = buffer.getInt();
        this.paths = new ArrayList<PartialPath>();
        for (int i = 0; i < pathSize; ++i) {
            this.paths.add(new PartialPath(this.readString(buffer)));
        }
        this.index = buffer.getLong();
    }
}

