/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.factory.AggregateResultFactory;
import org.apache.iotdb.db.utils.AggregateUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class AggregationPlan
extends RawDataQueryPlan {
    private List<String> aggregations = new ArrayList<String>();
    private List<String> deduplicatedAggregations = new ArrayList<String>();
    private int level = -1;
    private final Map<String, AggregateResult> levelAggPaths = new LinkedHashMap<String, AggregateResult>();

    public AggregationPlan() {
        this.setOperatorType(Operator.OperatorType.AGGREGATION);
    }

    @Override
    public List<String> getAggregations() {
        return this.aggregations;
    }

    public void setAggregations(List<String> aggregations) {
        this.aggregations = aggregations;
    }

    public List<String> getDeduplicatedAggregations() {
        return this.deduplicatedAggregations;
    }

    public void addDeduplicatedAggregations(String aggregations) {
        this.deduplicatedAggregations.add(aggregations);
    }

    public void setDeduplicatedAggregations(List<String> deduplicatedAggregations) {
        this.deduplicatedAggregations = deduplicatedAggregations;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public Map<String, AggregateResult> getAggPathByLevel() throws QueryProcessException {
        if (!this.levelAggPaths.isEmpty()) {
            return this.levelAggPaths;
        }
        List<PartialPath> seriesPaths = this.getPaths();
        List<TSDataType> dataTypes = this.getDataTypes();
        try {
            for (int i = 0; i < seriesPaths.size(); ++i) {
                String transformedPath = AggregateUtils.generatePartialPathByLevel(seriesPaths.get(i).getFullPath(), this.getLevel());
                String key = this.getAggregations().get(i) + "(" + transformedPath + ")";
                if (this.levelAggPaths.containsKey(key)) continue;
                AggregateResult aggRet = AggregateResultFactory.getAggrResultByName(this.getAggregations().get(i), dataTypes.get(i));
                this.levelAggPaths.put(key, aggRet);
            }
        }
        catch (IllegalPathException e) {
            throw new QueryProcessException(e.getMessage());
        }
        return this.levelAggPaths;
    }

    @Override
    public void setAlignByTime(boolean align) throws QueryProcessException {
        if (!align) {
            throw new QueryProcessException(this.getOperatorType().name() + " doesn't support disable align clause.");
        }
    }

    @Override
    public String getColumnForReaderFromPath(PartialPath path, int pathIndex) {
        String columnForReader = super.getColumnForReaderFromPath(path, pathIndex);
        if (!path.isTsAliasExists()) {
            columnForReader = this.getAggregations().get(pathIndex) + "(" + columnForReader + ")";
        }
        return columnForReader;
    }

    @Override
    public String getColumnForDisplay(String columnForReader, int pathIndex) throws IllegalPathException {
        String columnForDisplay = columnForReader;
        if (this.level >= 0) {
            PartialPath path = (PartialPath)this.paths.get(pathIndex);
            String aggregatePath = path.isMeasurementAliasExists() ? AggregateUtils.generatePartialPathByLevel(path.getFullPathWithAlias(), this.level) : AggregateUtils.generatePartialPathByLevel(path.toString(), this.level);
            columnForDisplay = this.aggregations.get(pathIndex) + "(" + aggregatePath + ")";
        }
        return columnForDisplay;
    }
}

