/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metrics.server;

import com.codahale.metrics.MetricRegistry;
import java.util.ArrayList;
import org.apache.iotdb.db.metrics.server.ServerArgument;
import org.apache.iotdb.db.metrics.sink.MetricsServletSink;
import org.apache.iotdb.db.metrics.sink.Sink;
import org.apache.iotdb.db.metrics.source.MetricsSource;
import org.apache.iotdb.db.metrics.source.Source;
import org.eclipse.jetty.servlet.ServletContextHandler;

public class MetricsSystem {
    private ArrayList<Sink> sinks = new ArrayList();
    private ArrayList<Source> sources = new ArrayList();
    private MetricRegistry metricRegistry = new MetricRegistry();
    private ServerArgument serverArgument;

    public MetricsSystem(ServerArgument serverArgument) {
        this.serverArgument = serverArgument;
    }

    public ServerArgument getServerArgument() {
        return this.serverArgument;
    }

    public void setServerArgument(ServerArgument serverArgument) {
        this.serverArgument = serverArgument;
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public ServletContextHandler getServletHandlers() {
        return new MetricsServletSink(this.metricRegistry).getHandler();
    }

    public void start() {
        this.registerSource();
        this.registerSinks();
        this.sinks.forEach(Sink::start);
    }

    public void stop() {
        this.sinks.forEach(Sink::stop);
    }

    public void report() {
        this.sinks.forEach(Sink::report);
    }

    public void registerSource() {
        MetricsSource source = new MetricsSource(this.serverArgument, this.metricRegistry);
        source.registerInfo();
        this.sources.add(source);
    }

    public void registerSinks() {
    }
}

