/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metrics.server;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class JettyUtil {
    public static ServletContextHandler createMetricsServletHandler(final ObjectMapper mapper, final MetricRegistry metricRegistry) {
        HttpServlet httpServlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;
            private final ObjectMapper om;
            private final MetricRegistry mr;
            {
                this.om = mapper;
                this.mr = metricRegistry;
            }

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                resp.setContentType("text/html;charset=utf-8");
                resp.setStatus(200);
                PrintWriter out = resp.getWriter();
                out.write(this.om.writeValueAsString((Object)this.mr));
                out.flush();
                out.close();
            }

            public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                this.doGet(req, resp);
            }
        };
        return JettyUtil.createServletHandler("/json", httpServlet);
    }

    public static ServletContextHandler createServletHandler(String path, HttpServlet servlet) {
        ServletContextHandler contextHandler = new ServletContextHandler(1);
        ServletHolder holder = new ServletHolder((Servlet)servlet);
        contextHandler.setContextPath(path);
        contextHandler.addServlet(holder, "/");
        return contextHandler;
    }

    public static ServletContextHandler createStaticHandler() {
        ServletContextHandler contextHandler = new ServletContextHandler(1);
        URL res = JettyUtil.class.getClassLoader().getResource("iotdb/ui/static");
        DefaultServlet servlet = new DefaultServlet();
        ServletHolder holder = new ServletHolder((Servlet)servlet);
        holder.setInitParameter("resourceBase", res.toString());
        contextHandler.setContextPath("/static");
        contextHandler.addServlet(holder, "/");
        return contextHandler;
    }

    public static Server getJettyServer(List<ServletContextHandler> handlers, int port) {
        Server server = new Server(port);
        ErrorHandler errorHandler = new ErrorHandler();
        errorHandler.setShowStacks(true);
        errorHandler.setServer(server);
        server.addBean((Object)errorHandler);
        ContextHandlerCollection collection = new ContextHandlerCollection();
        ServletContextHandler[] sch = new ServletContextHandler[handlers.size()];
        for (int i = 0; i < handlers.size(); ++i) {
            sch[i] = handlers.get(i);
        }
        collection.setHandlers((Handler[])sch);
        server.setHandler((Handler)collection);
        return server;
    }
}

