/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf.directories.strategy;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.utils.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DirectoryStrategy {
    protected static final Logger logger = LoggerFactory.getLogger(DirectoryStrategy.class);
    List<String> folders = new ArrayList<String>();

    public void setFolders(List<String> folders) throws DiskSpaceInsufficientException {
        boolean hasSpace = false;
        for (String folder : folders) {
            if (!CommonUtils.hasSpace(folder)) continue;
            hasSpace = true;
            break;
        }
        if (!hasSpace) {
            IoTDBDescriptor.getInstance().getConfig().setReadOnly(true);
            throw new DiskSpaceInsufficientException(folders);
        }
        this.folders = folders;
    }

    public abstract int nextFolderIndex() throws DiskSpaceInsufficientException;
}

