/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.standalone;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.consensus.PartitionRegionId;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.consensus.ConsensusFactory;
import org.apache.iotdb.consensus.EmptyStateMachine;
import org.apache.iotdb.consensus.IConsensus;
import org.apache.iotdb.consensus.IStateMachine;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.common.request.ByteBufferConsensusRequest;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.common.response.ConsensusGenericResponse;
import org.apache.iotdb.consensus.common.response.ConsensusWriteResponse;
import org.apache.iotdb.consensus.config.ConsensusConfig;
import org.apache.iotdb.consensus.exception.ConsensusGroupAlreadyExistException;
import org.apache.iotdb.consensus.exception.ConsensusGroupNotExistException;
import org.apache.iotdb.consensus.exception.IllegalPeerEndpointException;
import org.apache.iotdb.consensus.exception.IllegalPeerNumException;
import org.apache.ratis.util.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StandAloneConsensusTest {
    private IConsensus consensusImpl;
    private final TestEntry entry1 = new TestEntry(0);
    private final ByteBufferConsensusRequest entry2 = new ByteBufferConsensusRequest(ByteBuffer.wrap(new byte[4]));
    private final ConsensusGroupId dataRegionId = new DataRegionId(0);
    private final ConsensusGroupId schemaRegionId = new SchemaRegionId(1);
    private final ConsensusGroupId configId = new PartitionRegionId(2);

    @Before
    public void setUp() throws Exception {
        this.consensusImpl = (IConsensus)ConsensusFactory.getConsensusImpl((String)"org.apache.iotdb.consensus.standalone.StandAloneConsensus", (ConsensusConfig)ConsensusConfig.newBuilder().setThisNodeId(1).setThisNode(new TEndPoint("0.0.0.0", 6667)).setStorageDir("target" + File.separator + "standalone").build(), gid -> {
            switch (gid.getType()) {
                case SchemaRegion: {
                    return new TestStateMachine(true);
                }
                case DataRegion: {
                    return new TestStateMachine(false);
                }
            }
            return new EmptyStateMachine();
        }).orElseThrow(() -> new IllegalArgumentException(String.format("Construct consensusImpl failed, Please check your consensus className %s", "org.apache.iotdb.consensus.standalone.StandAloneConsensus")));
        this.consensusImpl.start();
    }

    @After
    public void tearDown() throws Exception {
        this.consensusImpl.stop();
        FileUtils.deleteFully((File)new File("./target/standalone"));
    }

    @Test
    public void addConsensusGroup() {
        ConsensusGenericResponse response1 = this.consensusImpl.createPeer(this.dataRegionId, Collections.singletonList(new Peer(this.dataRegionId, 1, new TEndPoint("0.0.0.0", 6667))));
        Assert.assertTrue((boolean)response1.isSuccess());
        Assert.assertNull((Object)response1.getException());
        ConsensusGenericResponse response2 = this.consensusImpl.createPeer(this.dataRegionId, Collections.singletonList(new Peer(this.dataRegionId, 1, new TEndPoint("0.0.0.0", 6667))));
        Assert.assertFalse((boolean)response2.isSuccess());
        Assert.assertTrue((boolean)(response2.getException() instanceof ConsensusGroupAlreadyExistException));
        ConsensusGenericResponse response3 = this.consensusImpl.createPeer(this.dataRegionId, Arrays.asList(new Peer(this.dataRegionId, 1, new TEndPoint("0.0.0.0", 6667)), new Peer(this.dataRegionId, 1, new TEndPoint("0.0.0.1", 6667))));
        Assert.assertFalse((boolean)response3.isSuccess());
        Assert.assertTrue((boolean)(response3.getException() instanceof IllegalPeerNumException));
        ConsensusGenericResponse response4 = this.consensusImpl.createPeer(this.dataRegionId, Collections.singletonList(new Peer(this.dataRegionId, 1, new TEndPoint("0.0.0.1", 6667))));
        Assert.assertFalse((boolean)response4.isSuccess());
        Assert.assertTrue((boolean)(response4.getException() instanceof IllegalPeerEndpointException));
        ConsensusGenericResponse response5 = this.consensusImpl.createPeer(this.schemaRegionId, Collections.singletonList(new Peer(this.schemaRegionId, 1, new TEndPoint("0.0.0.0", 6667))));
        Assert.assertTrue((boolean)response5.isSuccess());
        Assert.assertNull((Object)response5.getException());
    }

    @Test
    public void removeConsensusGroup() {
        ConsensusGenericResponse response1 = this.consensusImpl.deletePeer(this.dataRegionId);
        Assert.assertFalse((boolean)response1.isSuccess());
        Assert.assertTrue((boolean)(response1.getException() instanceof ConsensusGroupNotExistException));
        ConsensusGenericResponse response2 = this.consensusImpl.createPeer(this.dataRegionId, Collections.singletonList(new Peer(this.dataRegionId, 1, new TEndPoint("0.0.0.0", 6667))));
        Assert.assertTrue((boolean)response2.isSuccess());
        Assert.assertNull((Object)response2.getException());
        ConsensusGenericResponse response3 = this.consensusImpl.deletePeer(this.dataRegionId);
        Assert.assertTrue((boolean)response3.isSuccess());
        Assert.assertNull((Object)response3.getException());
    }

    @Test
    public void addPeer() {
        ConsensusGenericResponse response = this.consensusImpl.addPeer(this.dataRegionId, new Peer(this.dataRegionId, 1, new TEndPoint("0.0.0.0", 6667)));
        Assert.assertFalse((boolean)response.isSuccess());
    }

    @Test
    public void removePeer() {
        ConsensusGenericResponse response = this.consensusImpl.removePeer(this.dataRegionId, new Peer(this.dataRegionId, 1, new TEndPoint("0.0.0.0", 6667)));
        Assert.assertFalse((boolean)response.isSuccess());
    }

    @Test
    public void changePeer() {
        ConsensusGenericResponse response = this.consensusImpl.changePeer(this.dataRegionId, Collections.singletonList(new Peer(this.dataRegionId, 1, new TEndPoint("0.0.0.0", 6667))));
        Assert.assertFalse((boolean)response.isSuccess());
    }

    @Test
    public void transferLeader() {
        ConsensusGenericResponse response = this.consensusImpl.transferLeader(this.dataRegionId, new Peer(this.dataRegionId, 1, new TEndPoint("0.0.0.0", 6667)));
        Assert.assertFalse((boolean)response.isSuccess());
    }

    @Test
    public void triggerSnapshot() {
        ConsensusGenericResponse response = this.consensusImpl.triggerSnapshot(this.dataRegionId);
        Assert.assertFalse((boolean)response.isSuccess());
    }

    @Test
    public void write() {
        ConsensusGenericResponse response1 = this.consensusImpl.createPeer(this.dataRegionId, Collections.singletonList(new Peer(this.dataRegionId, 1, new TEndPoint("0.0.0.0", 6667))));
        Assert.assertTrue((boolean)response1.isSuccess());
        Assert.assertNull((Object)response1.getException());
        ConsensusGenericResponse response2 = this.consensusImpl.createPeer(this.schemaRegionId, Collections.singletonList(new Peer(this.schemaRegionId, 1, new TEndPoint("0.0.0.0", 6667))));
        Assert.assertTrue((boolean)response2.isSuccess());
        Assert.assertNull((Object)response2.getException());
        ConsensusGenericResponse response3 = this.consensusImpl.createPeer(this.configId, Collections.singletonList(new Peer(this.configId, 1, new TEndPoint("0.0.0.0", 6667))));
        Assert.assertTrue((boolean)response3.isSuccess());
        Assert.assertNull((Object)response3.getException());
        ConsensusWriteResponse response4 = this.consensusImpl.write(this.dataRegionId, (IConsensusRequest)this.entry1);
        Assert.assertNull((Object)response4.getException());
        Assert.assertNotNull((Object)response4.getStatus());
        Assert.assertEquals((long)-1L, (long)response4.getStatus().getCode());
        ConsensusWriteResponse response5 = this.consensusImpl.write(this.schemaRegionId, (IConsensusRequest)this.entry1);
        Assert.assertNull((Object)response5.getException());
        Assert.assertNotNull((Object)response5.getStatus());
        Assert.assertEquals((long)1L, (long)response5.getStatus().getCode());
        ConsensusWriteResponse response6 = this.consensusImpl.write(this.configId, (IConsensusRequest)this.entry1);
        Assert.assertNull((Object)response6.getException());
        Assert.assertEquals((long)0L, (long)response6.getStatus().getCode());
        ConsensusWriteResponse response7 = this.consensusImpl.write(this.dataRegionId, (IConsensusRequest)this.entry2);
        Assert.assertNull((Object)response7.getException());
        Assert.assertEquals((long)0L, (long)response7.getStatus().getCode());
    }

    private static class TestStateMachine
    implements IStateMachine,
    IStateMachine.EventApi {
        private final boolean direction;

        public TestStateMachine(boolean direction) {
            this.direction = direction;
        }

        public void start() {
        }

        public void stop() {
        }

        public TSStatus write(IConsensusRequest request) {
            if (request instanceof ByteBufferConsensusRequest) {
                return new TSStatus(request.serializeToByteBuffer().getInt());
            }
            if (request instanceof TestEntry) {
                return new TSStatus(this.direction ? ((TestEntry)request).num + 1 : ((TestEntry)request).num - 1);
            }
            return new TSStatus();
        }

        public DataSet read(IConsensusRequest request) {
            return null;
        }

        public boolean takeSnapshot(File snapshotDir) {
            return false;
        }

        public void loadSnapshot(File latestSnapshotRootDir) {
        }
    }

    private static class TestEntry
    implements IConsensusRequest {
        private final int num;

        public TestEntry(int num) {
            this.num = num;
        }

        public ByteBuffer serializeToByteBuffer() {
            ByteBuffer buffer = ByteBuffer.allocate(4).putInt(this.num);
            buffer.flip();
            return buffer;
        }
    }
}

