/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.standalone;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.consensus.ConsensusFactory;
import org.apache.iotdb.consensus.EmptyStateMachine;
import org.apache.iotdb.consensus.IConsensus;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.common.response.ConsensusGenericResponse;
import org.apache.iotdb.consensus.config.ConsensusConfig;
import org.apache.iotdb.consensus.exception.ConsensusGroupAlreadyExistException;
import org.apache.ratis.util.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RecoveryTest {
    private final ConsensusGroupId schemaRegionId = new SchemaRegionId(1);
    private IConsensus consensusImpl;

    public void constructConsensus() throws IOException {
        this.consensusImpl = (IConsensus)ConsensusFactory.getConsensusImpl((String)"org.apache.iotdb.consensus.standalone.StandAloneConsensus", (ConsensusConfig)ConsensusConfig.newBuilder().setThisNodeId(1).setThisNode(new TEndPoint("0.0.0.0", 9000)).setStorageDir("target" + File.separator + "recovery").build(), gid -> new EmptyStateMachine()).orElseThrow(() -> new IllegalArgumentException(String.format("Construct consensusImpl failed, Please check your consensus className %s", "org.apache.iotdb.consensus.standalone.StandAloneConsensus")));
        this.consensusImpl.start();
    }

    @Before
    public void setUp() throws Exception {
        this.constructConsensus();
    }

    @After
    public void tearDown() throws IOException {
        this.consensusImpl.stop();
        FileUtils.deleteFully((File)new File("./target/recovery"));
    }

    @Test
    public void recoveryTest() throws Exception {
        this.consensusImpl.createPeer(this.schemaRegionId, Collections.singletonList(new Peer(this.schemaRegionId, 1, new TEndPoint("0.0.0.0", 9000))));
        this.consensusImpl.stop();
        this.consensusImpl = null;
        this.constructConsensus();
        ConsensusGenericResponse response = this.consensusImpl.createPeer(this.schemaRegionId, Collections.singletonList(new Peer(this.schemaRegionId, 1, new TEndPoint("0.0.0.0", 9000))));
        Assert.assertEquals((Object)response.getException().getMessage(), (Object)new ConsensusGroupAlreadyExistException(this.schemaRegionId).getMessage());
    }
}

