/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.ratis;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.consensus.IStateMachine;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.common.request.ByteBufferConsensusRequest;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtils {

    public static class IntegerCounter
    implements IStateMachine,
    IStateMachine.EventApi {
        private AtomicInteger integer;
        private final Logger logger = LoggerFactory.getLogger(IntegerCounter.class);
        private TEndPoint leaderEndpoint;
        private int leaderId;
        private List<Peer> configuration;

        public void start() {
            this.integer = new AtomicInteger(0);
        }

        public void stop() {
        }

        public TSStatus write(IConsensusRequest request) {
            TestRequest testRequest = request instanceof ByteBufferConsensusRequest ? new TestRequest(request.serializeToByteBuffer()) : (TestRequest)request;
            if (testRequest.isIncr()) {
                this.integer.incrementAndGet();
            }
            return new TSStatus(200);
        }

        public DataSet read(IConsensusRequest IConsensusRequest2) {
            TestDataSet dataSet = new TestDataSet();
            dataSet.setNumber(this.integer.get());
            return dataSet;
        }

        public boolean takeSnapshot(File snapshotDir) {
            File snapshot = new File(snapshotDir.getAbsolutePath() + File.separator + "snapshot");
            try (FileWriter writer = new FileWriter(snapshot);){
                writer.write(String.valueOf(this.integer.get()));
            }
            catch (IOException e) {
                this.logger.error("cannot open file writer of {}", (Object)snapshot);
                return false;
            }
            return true;
        }

        public void loadSnapshot(File latestSnapshotRootDir) {
            File snapshot = new File(latestSnapshotRootDir.getAbsolutePath() + File.separator + "snapshot");
            try (Scanner scanner = new Scanner(snapshot);){
                this.integer.set(Integer.parseInt(scanner.next()));
            }
            catch (FileNotFoundException e) {
                this.logger.error("cannot find snapshot file {}", (Object)snapshot);
            }
        }

        public void notifyLeaderChanged(ConsensusGroupId groupId, int newLeaderId) {
            this.leaderId = newLeaderId;
            System.out.println("---------newLeader-----------");
            System.out.println(groupId);
            System.out.println(newLeaderId);
            System.out.println("----------------------");
        }

        public void notifyConfigurationChanged(long term, long index, List<Peer> newConfiguration) {
            this.configuration = newConfiguration;
            System.out.println("----------newConfiguration------------");
            System.out.println("term : " + term);
            System.out.println("index : " + index);
            for (Peer peer : newConfiguration) {
                System.out.println(peer);
            }
            System.out.println("----------------------");
        }

        public static synchronized String ensureSnapshotFileName(File snapshotDir, String metadata) {
            File dir = new File(snapshotDir + File.separator + metadata);
            if (!dir.exists() || !dir.isDirectory()) {
                dir.mkdirs();
            }
            return dir.getPath() + File.separator + "snapshot";
        }

        public TEndPoint getLeaderEndpoint() {
            return this.leaderEndpoint;
        }

        public List<Peer> getConfiguration() {
            return this.configuration;
        }
    }

    public static class TestRequest
    implements IConsensusRequest {
        private final int cmd;

        public TestRequest(ByteBuffer buffer) {
            this.cmd = buffer.getInt();
        }

        public boolean isIncr() {
            return this.cmd == 1;
        }

        public ByteBuffer serializeToByteBuffer() {
            ByteBuffer buffer = ByteBuffer.allocate(4).putInt(this.cmd);
            buffer.flip();
            return buffer;
        }
    }

    public static class TestDataSet
    implements DataSet {
        private int number;

        public void setNumber(int number) {
            this.number = number;
        }

        public int getNumber() {
            return this.number;
        }
    }
}

