/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.ratis;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import org.apache.iotdb.consensus.IStateMachine;
import org.apache.iotdb.consensus.ratis.ApplicationStateMachineProxy;
import org.apache.iotdb.consensus.ratis.TestUtils;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.storage.FileInfo;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.server.storage.RaftStorageDirectory;
import org.apache.ratis.server.storage.RaftStorageMetadataFile;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.util.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SnapshotTest {
    private static final File testDir = new File("target" + File.separator + "sm");

    @Before
    public void setUp() throws IOException {
        FileUtils.createDirectories((File)testDir);
    }

    @After
    public void tearDown() throws IOException {
        FileUtils.deleteFully((File)testDir);
    }

    @Test
    public void testSnapshot() throws Exception {
        ApplicationStateMachineProxy proxy = new ApplicationStateMachineProxy((IStateMachine)new TestUtils.IntegerCounter(), null);
        proxy.initialize(null, null, (RaftStorage)new EmptyStorageWithOnlySMDir());
        proxy.notifyTermIndexUpdated(421L, 616L);
        String snapshotFilename = TestUtils.IntegerCounter.ensureSnapshotFileName(testDir, "421_616");
        long index = proxy.takeSnapshot();
        Assert.assertEquals((long)index, (long)616L);
        Assert.assertTrue((boolean)new File(snapshotFilename).exists());
        proxy.notifyTermIndexUpdated(616L, 4217L);
        String snapshotFilenameLatest = TestUtils.IntegerCounter.ensureSnapshotFileName(testDir, "616_4217");
        long indexLatest = proxy.takeSnapshot();
        Assert.assertEquals((long)indexLatest, (long)4217L);
        Assert.assertTrue((boolean)new File(snapshotFilenameLatest).exists());
        SnapshotInfo info = proxy.getLatestSnapshot();
        Assert.assertEquals((long)info.getTerm(), (long)616L);
        Assert.assertEquals((long)info.getIndex(), (long)4217L);
        proxy.getStateMachineStorage().cleanupOldSnapshots(null);
        Assert.assertFalse((boolean)new File(snapshotFilename).exists());
        Assert.assertTrue((boolean)new File(snapshotFilenameLatest).exists());
    }

    @Test
    public void testCrossDiskLinkSnapshot() throws Exception {
        ApplicationStateMachineProxy proxy = new ApplicationStateMachineProxy((IStateMachine)new CrossDiskLinkStatemachine(), null);
        proxy.initialize(null, null, (RaftStorage)new EmptyStorageWithOnlySMDir());
        proxy.notifyTermIndexUpdated(20L, 1005L);
        proxy.takeSnapshot();
        String actualSnapshotName = CrossDiskLinkStatemachine.ensureSnapshotFileName(testDir, "20_1005");
        File actualSnapshotFile = new File(actualSnapshotName);
        Assert.assertEquals((long)proxy.getLatestSnapshot().getFiles().size(), (long)1L);
        Assert.assertEquals((Object)((FileInfo)proxy.getLatestSnapshot().getFiles().get(0)).getPath().toFile().getAbsolutePath(), (Object)actualSnapshotFile.getAbsolutePath());
    }

    static class CrossDiskLinkStatemachine
    extends TestUtils.IntegerCounter {
        CrossDiskLinkStatemachine() {
        }

        @Override
        public boolean takeSnapshot(File snapshotDir) {
            File snapshotRaw = new File(snapshotDir.getAbsolutePath() + File.separator + "snapshot");
            File snapshotRecord = new File(snapshotDir.getAbsolutePath() + File.separator + "record");
            try {
                Assert.assertTrue((boolean)snapshotRaw.createNewFile());
                FileWriter writer = new FileWriter(snapshotRecord);
                writer.write(snapshotRaw.getName());
                writer.close();
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
            return true;
        }

        public List<Path> getSnapshotFiles(File latestSnapshotRootDir) {
            File log = new File(latestSnapshotRootDir.getAbsolutePath() + File.separator + "record");
            Assert.assertTrue((boolean)log.exists());
            Scanner scanner = null;
            String relativePath = null;
            try {
                scanner = new Scanner(log);
                relativePath = scanner.nextLine();
                scanner.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            Assert.assertNotNull((Object)scanner);
            return Collections.singletonList(new File(latestSnapshotRootDir, relativePath).toPath());
        }
    }

    private static class EmptyStorageWithOnlySMDir
    implements RaftStorage {
        private EmptyStorageWithOnlySMDir() {
        }

        public RaftStorageDirectory getStorageDir() {
            return new RaftStorageDirectory(){

                public File getRoot() {
                    return null;
                }

                public boolean isHealthy() {
                    return false;
                }

                public File getStateMachineDir() {
                    return testDir;
                }
            };
        }

        public RaftStorageMetadataFile getMetadataFile() {
            return null;
        }

        public RaftServerConfigKeys.Log.CorruptionPolicy getLogCorruptionPolicy() {
            return null;
        }

        public void close() throws IOException {
        }
    }
}

