/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.ratis;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.consensus.ConsensusFactory;
import org.apache.iotdb.consensus.IConsensus;
import org.apache.iotdb.consensus.common.ConsensusGroup;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.common.request.ByteBufferConsensusRequest;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.common.response.ConsensusReadResponse;
import org.apache.iotdb.consensus.common.response.ConsensusWriteResponse;
import org.apache.iotdb.consensus.config.ConsensusConfig;
import org.apache.iotdb.consensus.config.RatisConfig;
import org.apache.iotdb.consensus.ratis.TestUtils;
import org.apache.ratis.util.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RatisConsensusTest {
    private ConsensusGroupId gid;
    private List<Peer> peers;
    private List<File> peersStorage;
    private List<IConsensus> servers;
    private List<TestUtils.IntegerCounter> stateMachines;
    private ConsensusGroup group;
    CountDownLatch latch;

    private void makeServers() throws IOException {
        for (int i = 0; i < 3; ++i) {
            this.stateMachines.add(new TestUtils.IntegerCounter());
            RatisConfig config = RatisConfig.newBuilder().setLog(RatisConfig.Log.newBuilder().setPurgeUptoSnapshotIndex(true).setPurgeGap(10).setUnsafeFlushEnabled(false).build()).setSnapshot(RatisConfig.Snapshot.newBuilder().setAutoTriggerThreshold(100L).build()).build();
            int finalI = i;
            this.servers.add((IConsensus)ConsensusFactory.getConsensusImpl((String)"org.apache.iotdb.consensus.ratis.RatisConsensus", (ConsensusConfig)ConsensusConfig.newBuilder().setThisNodeId(this.peers.get(i).getNodeId()).setThisNode(this.peers.get(i).getEndpoint()).setRatisConfig(config).setStorageDir(this.peersStorage.get(i).getAbsolutePath()).build(), groupId -> this.stateMachines.get(finalI)).orElseThrow(() -> new IllegalArgumentException(String.format("Construct consensusImpl failed, Please check your consensus className %s", "org.apache.iotdb.consensus.ratis.RatisConsensus"))));
            this.servers.get(i).start();
        }
    }

    @Before
    public void setUp() throws IOException {
        this.gid = new DataRegionId(1);
        this.peers = new ArrayList<Peer>();
        this.peers.add(new Peer(this.gid, 1, new TEndPoint("127.0.0.1", 6000)));
        this.peers.add(new Peer(this.gid, 2, new TEndPoint("127.0.0.1", 6001)));
        this.peers.add(new Peer(this.gid, 3, new TEndPoint("127.0.0.1", 6002)));
        this.peersStorage = new ArrayList<File>();
        this.peersStorage.add(new File("target" + File.separator + "1"));
        this.peersStorage.add(new File("target" + File.separator + "2"));
        this.peersStorage.add(new File("target" + File.separator + "3"));
        for (File dir : this.peersStorage) {
            dir.mkdirs();
        }
        this.group = new ConsensusGroup(this.gid, this.peers);
        this.servers = new ArrayList<IConsensus>();
        this.stateMachines = new ArrayList<TestUtils.IntegerCounter>();
        this.makeServers();
    }

    @After
    public void tearDown() throws IOException {
        for (int i = 0; i < 3; ++i) {
            this.servers.get(i).stop();
        }
        for (File file : this.peersStorage) {
            FileUtils.deleteFully((File)file);
        }
    }

    @Test
    public void basicConsensus3Copy() throws Exception {
        this.servers.get(0).createPeer(this.group.getGroupId(), this.group.getPeers());
        this.servers.get(1).createPeer(this.group.getGroupId(), this.group.getPeers());
        this.servers.get(2).createPeer(this.group.getGroupId(), this.group.getPeers());
        this.doConsensus(this.servers.get(0), this.group.getGroupId(), 10, 10);
    }

    @Test
    public void addMemberToGroup() throws Exception {
        List<Peer> original = this.peers.subList(0, 1);
        this.servers.get(0).createPeer(this.group.getGroupId(), original);
        this.doConsensus(this.servers.get(0), this.group.getGroupId(), 10, 10);
        this.servers.get(1).createPeer(this.group.getGroupId(), this.peers);
        this.servers.get(0).addPeer(this.group.getGroupId(), this.peers.get(1));
        this.servers.get(2).createPeer(this.group.getGroupId(), this.peers);
        this.servers.get(0).changePeer(this.group.getGroupId(), this.peers);
        Assert.assertEquals((long)this.stateMachines.get(0).getConfiguration().size(), (long)3L);
        this.doConsensus(this.servers.get(0), this.group.getGroupId(), 10, 20);
    }

    @Test
    public void removeMemberFromGroup() throws Exception {
        this.servers.get(0).createPeer(this.group.getGroupId(), this.group.getPeers());
        this.servers.get(1).createPeer(this.group.getGroupId(), this.group.getPeers());
        this.servers.get(2).createPeer(this.group.getGroupId(), this.group.getPeers());
        this.doConsensus(this.servers.get(0), this.group.getGroupId(), 10, 10);
        this.servers.get(0).transferLeader(this.gid, this.peers.get(0));
        this.servers.get(0).removePeer(this.gid, this.peers.get(1));
        this.servers.get(1).deletePeer(this.gid);
        this.servers.get(0).removePeer(this.gid, this.peers.get(2));
        this.servers.get(2).deletePeer(this.gid);
        this.doConsensus(this.servers.get(0), this.group.getGroupId(), 10, 20);
    }

    @Test
    public void oneMemberGroupChange1() throws Exception {
        this.oneMemberGroupChangeImpl(false);
    }

    @Test
    public void oneMemberGroupChange2() throws Exception {
        this.oneMemberGroupChangeImpl(true);
    }

    private void oneMemberGroupChangeImpl(boolean previousRemove) throws Exception {
        this.servers.get(0).createPeer(this.group.getGroupId(), this.peers.subList(0, 1));
        this.doConsensus(this.servers.get(0), this.group.getGroupId(), 10, 10);
        this.servers.get(1).createPeer(this.group.getGroupId(), this.peers.subList(0, 2));
        this.servers.get(0).addPeer(this.group.getGroupId(), this.peers.get(1));
        this.servers.get(1).transferLeader(this.group.getGroupId(), this.peers.get(1));
        this.servers.get(previousRemove ? 0 : 1).removePeer(this.group.getGroupId(), this.peers.get(0));
        this.servers.get(0).deletePeer(this.group.getGroupId());
    }

    @Test
    public void crashAndStart() throws Exception {
        this.servers.get(0).createPeer(this.group.getGroupId(), this.group.getPeers());
        this.servers.get(1).createPeer(this.group.getGroupId(), this.group.getPeers());
        this.servers.get(2).createPeer(this.group.getGroupId(), this.group.getPeers());
        this.doConsensus(this.servers.get(0), this.group.getGroupId(), 200, 200);
        for (IConsensus consensus : this.servers) {
            consensus.stop();
        }
        this.servers.clear();
        this.makeServers();
        this.servers.get(0).createPeer(this.group.getGroupId(), this.group.getPeers());
        this.servers.get(1).createPeer(this.group.getGroupId(), this.group.getPeers());
        this.servers.get(2).createPeer(this.group.getGroupId(), this.group.getPeers());
        this.doConsensus(this.servers.get(0), this.gid, 10, 210);
    }

    private void doConsensus(IConsensus consensus, ConsensusGroupId gid, int count, int target) throws Exception {
        long current;
        this.latch = new CountDownLatch(count);
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        for (int i = 0; i < count; ++i) {
            executorService.submit(() -> {
                ByteBuffer incr = ByteBuffer.allocate(4);
                incr.putInt(1);
                incr.flip();
                ByteBufferConsensusRequest incrReq = new ByteBufferConsensusRequest(incr);
                ConsensusWriteResponse response = consensus.write(gid, (IConsensusRequest)incrReq);
                if (response.getException() != null) {
                    response.getException().printStackTrace(System.out);
                }
                Assert.assertEquals((long)response.getStatus().getCode(), (long)200L);
                this.latch.countDown();
            });
        }
        executorService.shutdown();
        Assert.assertTrue((boolean)this.latch.await(60L, TimeUnit.SECONDS));
        ByteBuffer get = ByteBuffer.allocate(4);
        get.putInt(2);
        get.flip();
        ByteBufferConsensusRequest getReq = new ByteBufferConsensusRequest(get);
        long start = System.currentTimeMillis();
        IConsensus leader = null;
        while (leader == null && (current = System.currentTimeMillis()) - start <= 60000L) {
            for (int i = 0; i < 3; ++i) {
                if (!this.servers.get(i).isLeader(gid)) continue;
                leader = this.servers.get(i);
            }
        }
        Assert.assertNotNull(leader);
        ConsensusReadResponse response = leader.read(gid, (IConsensusRequest)getReq);
        TestUtils.TestDataSet result = (TestUtils.TestDataSet)response.getDataset();
        Assert.assertEquals((long)target, (long)result.getNumber());
    }
}

