/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.multileader.util;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.consensus.IStateMachine;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.common.request.BatchIndexedConsensusRequest;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.common.request.IndexedConsensusRequest;
import org.apache.iotdb.consensus.multileader.util.FakeConsensusReqReader;
import org.apache.iotdb.consensus.multileader.util.RequestSets;
import org.apache.iotdb.consensus.multileader.util.TestEntry;
import org.apache.iotdb.consensus.multileader.wal.GetConsensusReqReaderPlan;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestStateMachine
implements IStateMachine,
IStateMachine.EventApi {
    private static final Logger logger = LoggerFactory.getLogger(TestStateMachine.class);
    private final RequestSets requestSets = new RequestSets(ConcurrentHashMap.newKeySet());

    public Set<IndexedConsensusRequest> getRequestSet() {
        return this.requestSets.getRequestSet();
    }

    public Set<TestEntry> getData() {
        HashSet<TestEntry> data = new HashSet<TestEntry>();
        this.requestSets.getRequestSet().forEach(x -> {
            for (IConsensusRequest request : x.getRequests()) {
                data.add((TestEntry)request);
            }
        });
        return data;
    }

    public void start() {
    }

    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus write(IConsensusRequest request) {
        RequestSets requestSets = this.requestSets;
        synchronized (requestSets) {
            if (request instanceof IndexedConsensusRequest) {
                this.writeOneRequest((IndexedConsensusRequest)request);
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            }
            if (request instanceof BatchIndexedConsensusRequest) {
                BatchIndexedConsensusRequest batchIndexedConsensusRequest = (BatchIndexedConsensusRequest)request;
                ArrayList<TSStatus> subStatus = new ArrayList<TSStatus>();
                for (IndexedConsensusRequest innerRequest : batchIndexedConsensusRequest.getRequests()) {
                    this.writeOneRequest(innerRequest);
                    subStatus.add(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
                }
                return new TSStatus().setSubStatus(subStatus);
            }
            logger.error("Unknown request: {}", (Object)request);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR);
        }
    }

    private void writeOneRequest(IndexedConsensusRequest indexedConsensusRequest) {
        ArrayList<TestEntry> transformedRequest = new ArrayList<TestEntry>();
        for (IConsensusRequest innerRequest : indexedConsensusRequest.getRequests()) {
            ByteBuffer buffer = innerRequest.serializeToByteBuffer();
            transformedRequest.add(new TestEntry(buffer.getInt(), Peer.deserialize((ByteBuffer)buffer)));
        }
        this.requestSets.add(new IndexedConsensusRequest(indexedConsensusRequest.getSearchIndex(), transformedRequest), indexedConsensusRequest.getSearchIndex() != -1L);
    }

    public synchronized DataSet read(IConsensusRequest request) {
        if (request instanceof GetConsensusReqReaderPlan) {
            return new FakeConsensusReqReader(this.requestSets);
        }
        return null;
    }

    public boolean takeSnapshot(File snapshotDir) {
        return false;
    }

    public void loadSnapshot(File latestSnapshotRootDir) {
    }
}

