/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.multileader.util;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.common.request.MultiLeaderConsensusRequest;
import org.apache.iotdb.tsfile.utils.PublicBAOS;

public class TestEntry
extends MultiLeaderConsensusRequest {
    private final int num;
    private final Peer peer;

    public TestEntry(int num, Peer peer) {
        super(ByteBuffer.allocate(4));
        this.num = num;
        this.peer = peer;
        ByteBuffer buffer = super.serializeToByteBuffer();
        buffer.putInt(num);
        buffer.clear();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ByteBuffer serializeToByteBuffer() {
        try (PublicBAOS publicBAOS = new PublicBAOS();){
            ByteBuffer byteBuffer;
            try (DataOutputStream outputStream = new DataOutputStream((OutputStream)publicBAOS);){
                outputStream.writeInt(this.num);
                this.peer.serialize(outputStream);
                byteBuffer = ByteBuffer.wrap(publicBAOS.getBuf(), 0, publicBAOS.size());
            }
            return byteBuffer;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TestEntry testEntry = (TestEntry)((Object)o);
        return this.num == testEntry.num && Objects.equals(this.peer, testEntry.peer);
    }

    public int hashCode() {
        return Objects.hash(this.num, this.peer);
    }

    public String toString() {
        return "TestEntry{num=" + this.num + ", peer=" + this.peer + '}';
    }
}

