/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.multileader.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.request.IndexedConsensusRequest;
import org.apache.iotdb.consensus.multileader.util.RequestSets;
import org.apache.iotdb.consensus.multileader.wal.ConsensusReqReader;

public class FakeConsensusReqReader
implements ConsensusReqReader,
DataSet {
    private final RequestSets requestSets;

    public FakeConsensusReqReader(RequestSets requestSets) {
        this.requestSets = requestSets;
    }

    public void setSafelyDeletedSearchIndex(long safelyDeletedSearchIndex) {
    }

    public ConsensusReqReader.ReqIterator getReqIterator(long startIndex) {
        return new FakeConsensusReqIterator(startIndex);
    }

    public long getCurrentSearchIndex() {
        return this.requestSets.getLocalRequestNumber();
    }

    public long getTotalSize() {
        return 0L;
    }

    private class FakeConsensusReqIterator
    implements ConsensusReqReader.ReqIterator {
        private long nextSearchIndex;

        public FakeConsensusReqIterator(long startIndex) {
            this.nextSearchIndex = startIndex;
        }

        public boolean hasNext() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IndexedConsensusRequest next() {
            RequestSets requestSets = FakeConsensusReqReader.this.requestSets;
            synchronized (requestSets) {
                for (IndexedConsensusRequest indexedConsensusRequest : FakeConsensusReqReader.this.requestSets.getRequestSet()) {
                    if (indexedConsensusRequest.getSearchIndex() != this.nextSearchIndex) continue;
                    ++this.nextSearchIndex;
                    return indexedConsensusRequest;
                }
                return null;
            }
        }

        public void waitForNextReady() throws InterruptedException {
            while (!this.hasNext()) {
                FakeConsensusReqReader.this.requestSets.waitForNextReady();
            }
        }

        public void waitForNextReady(long time, TimeUnit unit) throws InterruptedException, TimeoutException {
            while (!this.hasNext()) {
                FakeConsensusReqReader.this.requestSets.waitForNextReady(time, unit);
            }
        }

        public void skipTo(long targetIndex) {
            this.nextSearchIndex = targetIndex;
        }
    }
}

