/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.multileader.logdispatcher;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.iotdb.consensus.config.MultiLeaderConfig;
import org.apache.iotdb.consensus.multileader.logdispatcher.IndexController;
import org.apache.iotdb.consensus.multileader.logdispatcher.PendingBatch;
import org.apache.iotdb.consensus.multileader.logdispatcher.SyncStatus;
import org.apache.ratis.util.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SyncStatusTest {
    private static final File storageDir = new File("target" + File.separator + "test");
    private static final String prefix = "version";
    private static final MultiLeaderConfig config = new MultiLeaderConfig.Builder().build();
    private static final long CHECK_POINT_GAP = 500L;

    @Before
    public void setUp() throws IOException {
        FileUtils.createDirectories((File)storageDir);
    }

    @After
    public void tearDown() throws IOException {
        FileUtils.deleteFully((File)storageDir);
    }

    @Test
    public void sequenceTest() throws InterruptedException {
        IndexController controller = new IndexController(storageDir.getAbsolutePath(), prefix, 0L, 500L);
        Assert.assertEquals((long)0L, (long)controller.getCurrentIndex());
        SyncStatus status = new SyncStatus(controller, config);
        ArrayList<PendingBatch> batchList = new ArrayList<PendingBatch>();
        for (long i = 0L; i < (long)config.getReplication().getMaxPendingBatch(); ++i) {
            PendingBatch batch = new PendingBatch(i, i, Collections.emptyList());
            batchList.add(batch);
            status.addNextBatch(batch);
        }
        for (int i = 0; i < config.getReplication().getMaxPendingBatch(); ++i) {
            status.removeBatch((PendingBatch)batchList.get(i));
            Assert.assertEquals((long)(config.getReplication().getMaxPendingBatch() - 1 - i), (long)status.getPendingBatches().size());
            Assert.assertEquals((long)i, (long)controller.getCurrentIndex());
            Assert.assertEquals((long)config.getReplication().getMaxPendingBatch(), (long)status.getNextSendingIndex());
        }
    }

    @Test
    public void reverseTest() throws InterruptedException {
        IndexController controller = new IndexController(storageDir.getAbsolutePath(), prefix, 0L, 500L);
        Assert.assertEquals((long)0L, (long)controller.getCurrentIndex());
        Assert.assertEquals((long)0L, (long)controller.getLastFlushedIndex());
        SyncStatus status = new SyncStatus(controller, config);
        ArrayList<PendingBatch> batchList = new ArrayList<PendingBatch>();
        for (long i = 0L; i < (long)config.getReplication().getMaxPendingBatch(); ++i) {
            PendingBatch batch = new PendingBatch(i, i, Collections.emptyList());
            batchList.add(batch);
            status.addNextBatch(batch);
        }
        for (int i = 0; i < config.getReplication().getMaxPendingBatch() - 1; ++i) {
            status.removeBatch((PendingBatch)batchList.get(config.getReplication().getMaxPendingBatch() - 1 - i));
            Assert.assertEquals((long)config.getReplication().getMaxPendingBatch(), (long)status.getPendingBatches().size());
            Assert.assertEquals((long)0L, (long)controller.getCurrentIndex());
            Assert.assertEquals((long)config.getReplication().getMaxPendingBatch(), (long)status.getNextSendingIndex());
        }
        status.removeBatch((PendingBatch)batchList.get(0));
        Assert.assertEquals((long)0L, (long)status.getPendingBatches().size());
        Assert.assertEquals((long)(config.getReplication().getMaxPendingBatch() - 1), (long)controller.getCurrentIndex());
        Assert.assertEquals((long)config.getReplication().getMaxPendingBatch(), (long)status.getNextSendingIndex());
    }

    @Test
    public void mixedTest() throws InterruptedException {
        int i;
        IndexController controller = new IndexController(storageDir.getAbsolutePath(), prefix, 0L, 500L);
        Assert.assertEquals((long)0L, (long)controller.getCurrentIndex());
        Assert.assertEquals((long)0L, (long)controller.getLastFlushedIndex());
        SyncStatus status = new SyncStatus(controller, config);
        ArrayList<PendingBatch> batchList = new ArrayList<PendingBatch>();
        for (long i2 = 0L; i2 < (long)config.getReplication().getMaxPendingBatch(); ++i2) {
            PendingBatch batch = new PendingBatch(i2, i2, Collections.emptyList());
            batchList.add(batch);
            status.addNextBatch(batch);
        }
        for (i = 0; i < config.getReplication().getMaxPendingBatch() / 2; ++i) {
            status.removeBatch((PendingBatch)batchList.get(i));
            Assert.assertEquals((long)(config.getReplication().getMaxPendingBatch() - 1 - i), (long)status.getPendingBatches().size());
            Assert.assertEquals((long)i, (long)controller.getCurrentIndex());
            Assert.assertEquals((long)config.getReplication().getMaxPendingBatch(), (long)status.getNextSendingIndex());
        }
        for (i = config.getReplication().getMaxPendingBatch() / 2 + 1; i < config.getReplication().getMaxPendingBatch(); ++i) {
            status.removeBatch((PendingBatch)batchList.get(i));
            Assert.assertEquals((long)(config.getReplication().getMaxPendingBatch() - config.getReplication().getMaxPendingBatch() / 2), (long)status.getPendingBatches().size());
            Assert.assertEquals((long)config.getReplication().getMaxPendingBatch(), (long)status.getNextSendingIndex());
        }
        status.removeBatch((PendingBatch)batchList.get(config.getReplication().getMaxPendingBatch() / 2));
        Assert.assertEquals((long)0L, (long)status.getPendingBatches().size());
        Assert.assertEquals((long)(config.getReplication().getMaxPendingBatch() - 1), (long)controller.getCurrentIndex());
        Assert.assertEquals((long)config.getReplication().getMaxPendingBatch(), (long)status.getNextSendingIndex());
    }

    @Test
    public void waitTest() throws InterruptedException, ExecutionException {
        IndexController controller = new IndexController(storageDir.getAbsolutePath(), prefix, 0L, 500L);
        Assert.assertEquals((long)0L, (long)controller.getCurrentIndex());
        SyncStatus status = new SyncStatus(controller, config);
        ArrayList<PendingBatch> batchList = new ArrayList<PendingBatch>();
        for (long i = 0L; i < (long)config.getReplication().getMaxPendingBatch(); ++i) {
            PendingBatch batch = new PendingBatch(i, i, Collections.emptyList());
            batchList.add(batch);
            status.addNextBatch(batch);
        }
        for (int i = 0; i < config.getReplication().getMaxPendingBatch() - 1; ++i) {
            status.removeBatch((PendingBatch)batchList.get(config.getReplication().getMaxPendingBatch() - 1 - i));
            Assert.assertEquals((long)config.getReplication().getMaxPendingBatch(), (long)status.getPendingBatches().size());
            Assert.assertEquals((long)0L, (long)controller.getCurrentIndex());
            Assert.assertEquals((long)config.getReplication().getMaxPendingBatch(), (long)status.getNextSendingIndex());
        }
        CompletableFuture<Boolean> future = CompletableFuture.supplyAsync(() -> {
            PendingBatch batch = new PendingBatch((long)config.getReplication().getMaxPendingBatch(), (long)config.getReplication().getMaxPendingBatch(), Collections.emptyList());
            batchList.add(batch);
            try {
                status.addNextBatch(batch);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
            return true;
        });
        Thread.sleep(1000L);
        Assert.assertFalse((boolean)future.isDone());
        status.removeBatch((PendingBatch)batchList.get(0));
        Assert.assertTrue((boolean)future.get());
        Assert.assertEquals((long)1L, (long)status.getPendingBatches().size());
        Assert.assertEquals((long)(config.getReplication().getMaxPendingBatch() - 1), (long)controller.getCurrentIndex());
        Assert.assertEquals((long)(config.getReplication().getMaxPendingBatch() + 1), (long)status.getNextSendingIndex());
        status.removeBatch((PendingBatch)batchList.get(config.getReplication().getMaxPendingBatch()));
        Assert.assertEquals((long)0L, (long)status.getPendingBatches().size());
        Assert.assertEquals((long)config.getReplication().getMaxPendingBatch(), (long)controller.getCurrentIndex());
        Assert.assertEquals((long)(config.getReplication().getMaxPendingBatch() + 1), (long)status.getNextSendingIndex());
    }
}

