/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.multileader.logdispatcher;

import java.io.File;
import java.io.IOException;
import org.apache.iotdb.consensus.multileader.logdispatcher.IndexController;
import org.apache.ratis.util.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IndexControllerTest {
    private static final File storageDir = new File("target" + File.separator + "test");
    private static final String prefix = "version";
    private static final long CHECK_POINT_GAP = 500L;

    @Before
    public void setUp() throws IOException {
        FileUtils.createDirectories((File)storageDir);
    }

    @After
    public void tearDown() throws IOException {
        FileUtils.deleteFully((File)storageDir);
    }

    @Test
    public void testIncrementIntervalAfterRestart() {
        IndexController controller = new IndexController(storageDir.getAbsolutePath(), prefix, 0L, 500L);
        Assert.assertEquals((long)0L, (long)controller.getCurrentIndex());
        Assert.assertEquals((long)0L, (long)controller.getLastFlushedIndex());
        controller.updateAndGet(499L);
        Assert.assertEquals((long)499L, (long)controller.getCurrentIndex());
        Assert.assertEquals((long)0L, (long)controller.getLastFlushedIndex());
        controller = new IndexController(storageDir.getAbsolutePath(), prefix, 0L, 500L);
        Assert.assertEquals((long)0L, (long)controller.getCurrentIndex());
        Assert.assertEquals((long)0L, (long)controller.getLastFlushedIndex());
        controller.updateAndGet(501L);
        Assert.assertEquals((long)501L, (long)controller.getCurrentIndex());
        Assert.assertEquals((long)500L, (long)controller.getLastFlushedIndex());
        controller = new IndexController(storageDir.getAbsolutePath(), prefix, 0L, 500L);
        Assert.assertEquals((long)500L, (long)controller.getCurrentIndex());
        Assert.assertEquals((long)500L, (long)controller.getLastFlushedIndex());
        controller.updateAndGet(999L);
        Assert.assertEquals((long)999L, (long)controller.getCurrentIndex());
        Assert.assertEquals((long)500L, (long)controller.getLastFlushedIndex());
        controller = new IndexController(storageDir.getAbsolutePath(), prefix, 0L, 500L);
        Assert.assertEquals((long)500L, (long)controller.getCurrentIndex());
        Assert.assertEquals((long)500L, (long)controller.getLastFlushedIndex());
        controller.updateAndGet(1001L);
        Assert.assertEquals((long)1001L, (long)controller.getCurrentIndex());
        Assert.assertEquals((long)1000L, (long)controller.getLastFlushedIndex());
    }
}

